/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.service;

import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Proxy;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.manager.SeleniumManager;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.manager.SeleniumManagerOutput;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.NoSuchDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.service.DriverService;

public class DriverFinder
extends Object {
    private static final Logger LOG = Logger.getLogger((String)DriverFinder.class.getName());
    private final DriverService service;
    private final Capabilities options;
    private final SeleniumManager seleniumManager;
    private boolean offline;
    private SeleniumManagerOutput.Result result;

    public DriverFinder(DriverService service, Capabilities options) {
        this(service, options, SeleniumManager.getInstance());
    }

    DriverFinder(DriverService service, Capabilities options, SeleniumManager seleniumManager) {
        this.service = service;
        this.options = options;
        this.seleniumManager = seleniumManager;
    }

    public String getDriverPath() {
        return this.getBinaryPaths().getDriverPath();
    }

    public String getBrowserPath() {
        return this.getBinaryPaths().getBrowserPath();
    }

    public boolean isAvailable() {
        try {
            this.offline = false;
            this.getBinaryPaths();
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.failed to discover driver path", (Throwable)((java.lang.Object)e));
            return false;
        }
    }

    public boolean isPresent() {
        try {
            this.offline = true;
            this.getBinaryPaths();
            return true;
        }
        catch (NoSuchDriverException e) {
            return false;
        }
        catch (IllegalStateException | WebDriverException e) {
            LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.failed to discover driver path", (Throwable)((java.lang.Object)e));
            return false;
        }
    }

    public boolean hasBrowserPath() {
        String browserPath = this.result.getBrowserPath();
        return browserPath != null && !browserPath.isEmpty();
    }

    private SeleniumManagerOutput.Result getBinaryPaths() {
        if (this.result == null) {
            try {
                String driverName = this.service.getDriverName();
                this.result = new SeleniumManagerOutput.Result(this.service.getExecutable());
                if (this.result.getDriverPath() == null) {
                    this.result = new SeleniumManagerOutput.Result(System.getProperty((String)this.service.getDriverProperty()));
                    if (this.result.getDriverPath() == null) {
                        List<String> arguments = this.toArguments();
                        this.result = this.seleniumManager.getBinaryPaths(arguments);
                        Require.state(this.options.getBrowserName(), Path.of((String)this.result.getBrowserPath(), (String[])new String[0])).isExecutable();
                    } else {
                        LOG.fine(String.format((String)"org.rascalmpl.org.rascalmpl.Skipping Selenium Manager, path to %s found in system property: %s", (Object[])new Object[]{driverName, this.result.getDriverPath()}));
                    }
                } else {
                    LOG.fine(String.format((String)"org.rascalmpl.org.rascalmpl.Skipping Selenium Manager, path to %s specified in Service class: %s", (Object[])new Object[]{driverName, this.result.getDriverPath()}));
                }
                Require.state(driverName, Path.of((String)this.result.getDriverPath(), (String[])new String[0])).isExecutable();
            }
            catch (RuntimeException e) {
                throw new NoSuchDriverException(String.format((String)"org.rascalmpl.org.rascalmpl.Unable to obtain: %s, error %s", (Object[])new Object[]{this.service.getDriverName(), e.getMessage()}), (Throwable)((java.lang.Object)e));
            }
        }
        return this.result;
    }

    private List<String> toArguments() {
        Proxy proxy;
        String browserBinary;
        ArrayList arguments = new ArrayList();
        arguments.add((Object)"org.rascalmpl.org.rascalmpl.--browser");
        arguments.add((Object)this.options.getBrowserName());
        if (!this.options.getBrowserVersion().isEmpty()) {
            arguments.add((Object)"org.rascalmpl.org.rascalmpl.--browser-version");
            arguments.add((Object)this.options.getBrowserVersion());
        }
        if ((browserBinary = DriverFinder.getBrowserBinary(this.options)) != null && !browserBinary.isEmpty()) {
            arguments.add((Object)"org.rascalmpl.org.rascalmpl.--browser-path");
            arguments.add((Object)browserBinary);
        }
        if (this.offline) {
            arguments.add((Object)"org.rascalmpl.org.rascalmpl.--offline");
        }
        if ((proxy = Proxy.extractFrom(this.options)) != null) {
            arguments.add((Object)"org.rascalmpl.org.rascalmpl.--proxy");
            if (proxy.getSslProxy() != null) {
                arguments.add((Object)proxy.getSslProxy());
            } else if (proxy.getHttpProxy() != null) {
                arguments.add((Object)proxy.getHttpProxy());
            }
        }
        return arguments;
    }

    private static String getBrowserBinary(Capabilities options) {
        List vendorOptionsCapabilities = Arrays.asList((Object[])new String[]{"org.rascalmpl.org.rascalmpl.moz:firefoxOptions", "org.rascalmpl.org.rascalmpl.goog:chromeOptions", "org.rascalmpl.org.rascalmpl.ms:edgeOptions"});
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey((Object)vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                return (String)vendorOptions.get((Object)"org.rascalmpl.org.rascalmpl.binary");
            }
            catch (Exception e) {
                LOG.warning(String.format((String)"org.rascalmpl.org.rascalmpl.Exception while retrieving the browser binary path. %s: %s", (Object[])new Object[]{options, e.getMessage()}));
            }
        }
        return null;
    }
}

