/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing;

import org.rascalmpl.org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.UUID;
import org.rascalmpl.org.rascalmpl.java.util.function.Function;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpHandler;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpRequest;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpResponse;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.AttributeKey;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.AttributeMap;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.HttpTracing;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.Span;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.Tags;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.TraceContext;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.Tracer;

public class SpanWrappedHttpHandler
extends Object
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger((String)SpanWrappedHttpHandler.class.getName());
    private final Tracer tracer;
    private final Function<HttpRequest, String> namer;
    private final HttpHandler delegate;

    public SpanWrappedHttpHandler(Tracer tracer, Function<HttpRequest, String> namer, HttpHandler delegate) {
        this.tracer = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Tracer", tracer);
        this.namer = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Naming function", namer);
        this.delegate = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Actual handler", delegate);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Object possibleSpan = req.getAttribute((String)"org.rascalmpl.org.rascalmpl.selenium.tracing.span");
        AttributeMap attributeMap = this.tracer.createAttributeMap();
        attributeMap.put(AttributeKey.HTTP_HANDLER_CLASS.getKey(), this.delegate.getClass().getName());
        if (possibleSpan instanceof Span) {
            return this.delegate.execute(req);
        }
        String name = Require.state((String)"org.rascalmpl.org.rascalmpl.Operation name", (String)this.namer.apply((Object)req)).nonNull((String)"org.rascalmpl.org.rascalmpl.must be set for %s", req);
        TraceContext before = this.tracer.getCurrentContext();
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, name);){
            TraceContext after = this.tracer.getCurrentContext();
            span.setAttribute((String)"org.rascalmpl.org.rascalmpl.random.key", UUID.randomUUID().toString());
            req.setAttribute((String)"org.rascalmpl.org.rascalmpl.selenium.tracing.span", span);
            if (!after.getClass().getName().equals((Object)"org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.empty.NullContext")) {
                LOG.fine(String.format((String)"org.rascalmpl.org.rascalmpl.Wrapping request. Before %s and after %s", (Object[])new Object[]{before, after}));
            }
            Tags.KIND.accept((Object)span, (Object)Span.Kind.SERVER);
            Tags.HTTP_REQUEST.accept((Object)span, (Object)req);
            Tags.HTTP_REQUEST_EVENT.accept((Object)attributeMap, (Object)req);
            HttpTracing.inject(this.tracer, span, req);
            HttpResponse res = this.delegate.execute(req);
            Tags.HTTP_RESPONSE.accept((Object)span, (Object)res);
            Tags.HTTP_RESPONSE_EVENT.accept((Object)attributeMap, (Object)res);
            span.addEvent((String)"org.rascalmpl.org.rascalmpl.HTTP request execution complete", attributeMap);
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }
}

