/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.support;

import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Short;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.util.regex.Matcher;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.Colors;

public class Color
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private final int red;
    private final int green;
    private final int blue;
    private double alpha;
    private static final Converter[] CONVERTERS = new Converter[]{new RgbConverter(), new RgbPctConverter(), new RgbaConverter(), new RgbaPctConverter(), new HexConverter(), new Hex3Converter(), new HslConverter(), new HslaConverter(), new NamedColorConverter()};

    public static Color fromString(String value) {
        for (Converter converter : CONVERTERS) {
            Color color = converter.getColor(value);
            if (color == null) continue;
            return color;
        }
        throw new IllegalArgumentException(String.format((String)"org.rascalmpl.org.rascalmpl.Did not know how to convert %s into color", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{value}));
    }

    public Color(int red, int green, int blue, double alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setOpacity(double alpha) {
        this.alpha = alpha;
    }

    public String asRgb() {
        return String.format((String)"org.rascalmpl.org.rascalmpl.rgb(%d, %d, %d)", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.red), Integer.valueOf((int)this.green), Integer.valueOf((int)this.blue)});
    }

    public String asRgba() {
        java.lang.String alphaString = this.alpha == 1.0 ? "org.rascalmpl.org.rascalmpl.1" : (this.alpha == 0.0 ? "org.rascalmpl.org.rascalmpl.0" : Double.toString((double)this.alpha));
        return String.format((String)"org.rascalmpl.org.rascalmpl.rgba(%d, %d, %d, %s)", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.red), Integer.valueOf((int)this.green), Integer.valueOf((int)this.blue), alphaString});
    }

    public String asHex() {
        return String.format((String)"org.rascalmpl.org.rascalmpl.#%02x%02x%02x", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.red), Integer.valueOf((int)this.green), Integer.valueOf((int)this.blue)});
    }

    public org.rascalmpl.org.rascalmpl.java.awt.Color getColor() {
        return new org.rascalmpl.org.rascalmpl.java.awt.Color(this.red, this.green, this.blue, (int)(this.alpha * 255.0));
    }

    public String toString() {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Color: \u0001"}, (String)this.asRgba());
    }

    public boolean equals(org.rascalmpl.org.rascalmpl.java.lang.Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Color)) {
            return false;
        }
        return this.asRgba().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)((Color)other).asRgba());
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        long temp = this.alpha != 0.0 ? Double.doubleToLongBits((double)this.alpha) : 0L;
        result = 31 * result + Long.hashCode((long)temp);
        return result;
    }

    private static abstract class Converter
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private Converter() {
        }

        public Color getColor(String value) {
            Matcher matcher = this.getPattern().matcher((CharSequence)value);
            if (matcher.find()) {
                double a = 1.0;
                if (matcher.groupCount() == 4) {
                    a = Double.parseDouble((String)matcher.group(4));
                }
                return this.createColor(matcher, a);
            }
            return null;
        }

        protected Color createColor(Matcher matcher, double a) {
            return new Color(this.fromMatchGroup(matcher, 1), this.fromMatchGroup(matcher, 2), this.fromMatchGroup(matcher, 3), a);
        }

        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort((String)matcher.group(index), (int)10);
        }

        protected abstract Pattern getPattern();
    }

    private static class RgbConverter
    extends Converter {
        private static final Pattern RGB_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.^\\s*rgb\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)\\s*$");

        private RgbConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGB_PATTERN;
        }
    }

    private static class RgbPctConverter
    extends Converter {
        private static final Pattern RGBPCT_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.^\\s*rgb\\(\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*\\)\\s*$");

        private RgbPctConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBPCT_PATTERN;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            double n = Double.parseDouble((String)matcher.group(index)) / 100.0 * 255.0;
            return (short)n;
        }
    }

    private static class RgbaConverter
    extends RgbConverter {
        private static final Pattern RGBA_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.^\\s*rgba\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(0|1|0\\.\\d+)\\s*\\)\\s*$");

        private RgbaConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBA_PATTERN;
        }
    }

    private static class RgbaPctConverter
    extends RgbPctConverter {
        private static final Pattern RGBAPCT_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.^\\s*rgba\\(\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d+)%\\s*,\\s*(0|1|0\\.\\d+)\\s*\\)\\s*$");

        private RgbaPctConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBAPCT_PATTERN;
        }
    }

    private static class HexConverter
    extends Converter {
        private static final Pattern HEX_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.#(\\p{XDigit}{2})(\\p{XDigit}{2})(\\p{XDigit}{2})");

        private HexConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX_PATTERN;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort((String)matcher.group(index), (int)16);
        }
    }

    private static class Hex3Converter
    extends Converter {
        private static final Pattern HEX3_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.#(\\p{XDigit}{1})(\\p{XDigit}{1})(\\p{XDigit}{1})");

        private Hex3Converter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX3_PATTERN;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001\u0001"}, (String)matcher.group(index), (String)matcher.group(index)), (int)16);
        }
    }

    private static class HslConverter
    extends Converter {
        private static final Pattern HSL_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.^\\s*hsl\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\%\\s*,\\s*(\\d{1,3})\\%\\s*\\)\\s*$");

        private HslConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HSL_PATTERN;
        }

        @Override
        protected Color createColor(Matcher matcher, double a) {
            double b;
            double g2;
            double r;
            double h2 = Double.parseDouble((String)matcher.group(1)) / 360.0;
            double s2 = Double.parseDouble((String)matcher.group(2)) / 100.0;
            double l = Double.parseDouble((String)matcher.group(3)) / 100.0;
            if (s2 == 0.0) {
                g2 = r = l;
                b = r;
            } else {
                double luminocity2 = l < 0.5 ? l * (1.0 + s2) : l + s2 - l * s2;
                double luminocity1 = 2.0 * l - luminocity2;
                r = this.hueToRgb(luminocity1, luminocity2, h2 + 0.3333333333333333);
                g2 = this.hueToRgb(luminocity1, luminocity2, h2);
                b = this.hueToRgb(luminocity1, luminocity2, h2 - 0.3333333333333333);
            }
            return new Color((short)Math.round((double)(r * 255.0)), (short)Math.round((double)(g2 * 255.0)), (short)Math.round((double)(b * 255.0)), a);
        }

        private double hueToRgb(double luminocity1, double luminocity2, double hue) {
            if (hue < 0.0) {
                hue += 1.0;
            }
            if (hue > 1.0) {
                hue -= 1.0;
            }
            if (hue < 0.16666666666666666) {
                return luminocity1 + (luminocity2 - luminocity1) * 6.0 * hue;
            }
            if (hue < 0.5) {
                return luminocity2;
            }
            if (hue < 0.6666666666666666) {
                return luminocity1 + (luminocity2 - luminocity1) * (0.6666666666666666 - hue) * 6.0;
            }
            return luminocity1;
        }
    }

    private static class HslaConverter
    extends HslConverter {
        private static final Pattern HSLA_PATTERN = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.^\\s*hsla\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\%\\s*,\\s*(\\d{1,3})\\%\\s*,\\s*(0|1|0\\.\\d+)\\s*\\)\\s*$");

        private HslaConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HSLA_PATTERN;
        }
    }

    private static class NamedColorConverter
    extends Converter {
        private NamedColorConverter() {
        }

        @Override
        public Color getColor(String value) {
            return Colors.valueOf(value.toUpperCase()).getColorValue();
        }

        @Override
        public Pattern getPattern() {
            throw new UnsupportedOperationException((String)"org.rascalmpl.org.rascalmpl.getPattern is unsupported");
        }
    }
}

