/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.locators;

import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.stream.Collectors;
import org.rascalmpl.org.rascalmpl.java.util.stream.Stream;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.By;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.JavascriptExecutor;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.SearchContext;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebElement;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.json.Json;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.json.JsonException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.locators.RelativeLocatorScript;

public class RelativeLocator
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static final Json JSON = new Json();
    private static final int CLOSE_IN_PIXELS = 50;

    public static RelativeBy with(By by) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.By to look for", by);
        return new RelativeBy(by);
    }

    private static org.rascalmpl.org.rascalmpl.java.lang.Object asAtomLocatorParameter(org.rascalmpl.org.rascalmpl.java.lang.Object object) {
        if (object instanceof WebElement) {
            return object;
        }
        if (!(object instanceof By)) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Expected locator to be either an element or a By: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)object)));
        }
        RelativeLocator.assertLocatorCanBeSerialized(object);
        Map raw = (Map)JSON.toType(JSON.toJson(object), Json.MAP_TYPE);
        if (!(raw.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.using") instanceof String)) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Expected JSON encoded form of locator to have a 'using' field. \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)raw)));
        }
        if (!raw.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value")) {
            throw new JsonException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Expected JSON encoded form of locator to have a 'value' field: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)raw)));
        }
        return Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)((String)raw.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.using")), (org.rascalmpl.org.rascalmpl.java.lang.Object)raw.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value"));
    }

    private static void assertLocatorCanBeSerialized(org.rascalmpl.org.rascalmpl.java.lang.Object locator) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
        Class clazz = locator.getClass();
        while (!clazz.equals(org.rascalmpl.org.rascalmpl.java.lang.Object.class)) {
            try {
                clazz.getDeclaredMethod((String)"org.rascalmpl.org.rascalmpl.toJson", new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Locator must be serializable to JSON using a `toJson` method. \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)locator)));
    }

    public static class RelativeBy
    extends By
    implements By.Remotable {
        private final org.rascalmpl.org.rascalmpl.java.lang.Object root;
        private final List<Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>> filters;

        private RelativeBy(org.rascalmpl.org.rascalmpl.java.lang.Object rootLocator) {
            this(rootLocator, (List<Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>>)List.of());
        }

        private RelativeBy(org.rascalmpl.org.rascalmpl.java.lang.Object rootLocator, List<Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>> filters) {
            if (rootLocator instanceof By) {
                RelativeLocator.assertLocatorCanBeSerialized(rootLocator);
                rootLocator = RelativeLocator.asAtomLocatorParameter(rootLocator);
            } else if (rootLocator instanceof Map) {
                if (((Map)rootLocator).keySet().size() != 1) {
                    throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Root locators as find element payload must only have a single key: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)rootLocator)));
                }
            } else if (!(rootLocator instanceof WebElement)) {
                throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Root locator must be an element or a locator: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)rootLocator)));
            }
            this.root = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Root locator", rootLocator);
            this.filters = List.copyOf((Collection)((Collection)Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Filters", filters)));
        }

        public RelativeBy above(WebElement element) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element to search above of", element);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.above", element);
        }

        public RelativeBy above(By locator) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.above", locator);
        }

        public RelativeBy below(WebElement element) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element to search below of", element);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.below", element);
        }

        public RelativeBy below(By locator) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.below", locator);
        }

        public RelativeBy toLeftOf(WebElement element) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element to search to left of", element);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.left", element);
        }

        public RelativeBy toLeftOf(By locator) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.left", locator);
        }

        public RelativeBy toRightOf(WebElement element) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element to search to right of", element);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.right", element);
        }

        public RelativeBy toRightOf(By locator) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection((String)"org.rascalmpl.org.rascalmpl.right", locator);
        }

        public RelativeBy near(WebElement element) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element to search near", element);
            return this.near(element, 50);
        }

        public RelativeBy near(WebElement element, int atMostDistanceInPixels) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element to search near", element);
            Require.positive((String)"org.rascalmpl.org.rascalmpl.Distance", Integer.valueOf((int)atMostDistanceInPixels));
            return this.near((org.rascalmpl.org.rascalmpl.java.lang.Object)element, atMostDistanceInPixels);
        }

        public RelativeBy near(By locator) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            return this.near((org.rascalmpl.org.rascalmpl.java.lang.Object)locator, 50);
        }

        public RelativeBy near(By locator, int atMostDistanceInPixels) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            Require.positive((String)"org.rascalmpl.org.rascalmpl.Distance", Integer.valueOf((int)atMostDistanceInPixels));
            return this.near((org.rascalmpl.org.rascalmpl.java.lang.Object)locator, atMostDistanceInPixels);
        }

        private RelativeBy near(org.rascalmpl.org.rascalmpl.java.lang.Object locator, int atMostDistanceInPixels) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            Require.positive((String)"org.rascalmpl.org.rascalmpl.Distance", Integer.valueOf((int)atMostDistanceInPixels));
            return new RelativeBy(this.root, this.amend((Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>)Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.kind", (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.near", (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.args", (org.rascalmpl.org.rascalmpl.java.lang.Object)List.of((org.rascalmpl.org.rascalmpl.java.lang.Object)RelativeLocator.asAtomLocatorParameter(locator), (org.rascalmpl.org.rascalmpl.java.lang.Object)Integer.valueOf((int)atMostDistanceInPixels)))));
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            JavascriptExecutor js = this.getJavascriptExecutor(context);
            List elements = (List)js.executeScript(RelativeLocatorScript.FIND_ELEMENTS, RelativeLocator.asAtomLocatorParameter(this));
            return elements;
        }

        private RelativeBy simpleDirection(String direction, org.rascalmpl.org.rascalmpl.java.lang.Object locator) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Direction to search in", direction);
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Locator", locator);
            return new RelativeBy(this.root, this.amend((Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>)Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.kind", (org.rascalmpl.org.rascalmpl.java.lang.Object)direction, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.args", (org.rascalmpl.org.rascalmpl.java.lang.Object)List.of((org.rascalmpl.org.rascalmpl.java.lang.Object)RelativeLocator.asAtomLocatorParameter(locator)))));
        }

        private List<Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>> amend(Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> toAdd) {
            return (List)Stream.concat((Stream)this.filters.stream(), (Stream)Stream.of(toAdd)).collect(Collectors.toUnmodifiableList());
        }

        @Override
        public By.Remotable.Parameters getRemoteParameters() {
            return new By.Remotable.Parameters((String)"org.rascalmpl.org.rascalmpl.relative", (org.rascalmpl.org.rascalmpl.java.lang.Object)Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.root", (org.rascalmpl.org.rascalmpl.java.lang.Object)this.root, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.filters", this.filters));
        }

        private Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> toJson() {
            return Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.using", (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.relative", (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value", (org.rascalmpl.org.rascalmpl.java.lang.Object)Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.root", (org.rascalmpl.org.rascalmpl.java.lang.Object)this.root, (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.filters", this.filters));
        }
    }
}

