/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.pagefactory;

import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.ReflectiveOperationException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.annotation.Annotation;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Field;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.By;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.AbstractFindByBuilder;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.ByIdOrName;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.CacheLookup;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.FindAll;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.FindBy;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.FindBys;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.PageFactoryFinder;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.support.pagefactory.AbstractAnnotations;

public class Annotations
extends AbstractAnnotations {
    private final Field field;

    public Annotations(Field field) {
        this.field = field;
    }

    @Override
    public boolean isLookupCached() {
        return this.field.getAnnotation(CacheLookup.class) != null;
    }

    @Override
    public By buildBy() {
        this.assertValidAnnotations();
        By ans = null;
        for (Annotation annotation : this.field.getDeclaredAnnotations()) {
            AbstractFindByBuilder builder = null;
            if (annotation.annotationType().isAnnotationPresent(PageFactoryFinder.class)) {
                try {
                    builder = (AbstractFindByBuilder)((PageFactoryFinder)annotation.annotationType().getAnnotation(PageFactoryFinder.class)).value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (builder == null) continue;
            ans = builder.buildIt((Object)annotation, this.field);
            break;
        }
        if (ans == null) {
            ans = this.buildByFromDefault();
        }
        return ans;
    }

    protected Field getField() {
        return this.field;
    }

    protected By buildByFromDefault() {
        return new ByIdOrName(this.field.getName());
    }

    protected void assertValidAnnotations() {
        FindBys findBys = (FindBys)this.field.getAnnotation(FindBys.class);
        FindAll findAll = (FindAll)this.field.getAnnotation(FindAll.class);
        FindBy findBy = (FindBy)this.field.getAnnotation(FindBy.class);
        if (findBys != null && findBy != null) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBy != null) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.If you use a '@FindAll' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBys != null) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.If you use a '@FindAll' annotation, you must not also use a '@FindBys' annotation");
        }
    }
}

