@license{
  Copyright (c) 2009-2015 CWI
  All rights reserved. This program and the accompanying materials
  are made available under the terms of the Eclipse Public License v1.0
  which accompanies this distribution, and is available at
  http://www.eclipse.org/legal/epl-v10.html
}
@contributor{Jurgen J. Vinju - Jurgen.Vinju@cwi.nl - CWI}
@contributor{Jeroen van den Bos - Jeroen.van.den.Bos@cwi.nl (CWI)}
@contributor{Paul Klint - Paul.Klint@cwi.nl - CWI}
@contributor{Arnold Lankamp - Arnold.Lankamp@cwi.nl}
@synopsis{Exceptions thrown by the Rascal run-time}
module Exception


@synopsis{The `Exception` datatype used in all Rascal exceptions.}
@description{
This data type declares all exceptions that are thrown by the
Rascal run-time environment which can be caught by a Rascal program.

Since declarations for data types are extensible, the user can add new exceptions when needed.
However, this is not necessary. The throw statement can throw any value.

Exceptions are either generated by the Rascal run-time (e.g., `IndexOutOfBounds`) or they
are generated by a throw statement. They can all be caught with a try-catch using pattern matching.
}
@examples{
Import relevant libraries:
```rascal-shell,continue
import Exception;
import IO;
```
Define the map `weekend` and do a subscription with a non-existing key:
```rascal-shell,continue,error
weekend = ("saturday": 1, "sunday": 2);
weekend["monday"];
```
Repeat this, but catch the exception. We use variable `N` to track what happened:
```rascal-shell,continue
N = 1;
try {
   N = weekend["monday"];
} catch NoSuchKey(v):
  N = 100;
println(N);
```
}
data RuntimeException 
    = Ambiguity(loc location, str nonterminal, str sentence)
    | ArithmeticException(str message)
    | AssertionFailed() 
    | AssertionFailed(str label)
    | CallFailed(list[value] arguments)
    | DateTimeParsingError(str message)
    | DateTimePrintingError(str message)
    | EmptyList()
    | EmptyMap() 
    | EmptySet()
    | IndexOutOfBounds(int index)
    | IllegalArgument()                        
    | IllegalArgument(value v)                 
    | IllegalArgument(value v, str message)  
    | IllegalTypeArgument(str cls, str message) 
    | ImplodeError(str message)
    | InvalidURI(str uri)
    | InvalidUseOfDate(str message)
    | InvalidUseOfDateTime(str message)
    | InvalidUseOfLocation(str message)
    | InvalidUseOfTime(str message)
 
    | IO(str message)
    | Java(str class, str message)             // deprecated
    | Java(str class, str message, RuntimeException cause) // deprecated
    | JavaException(str class, str message)
    | JavaException(str class, str message, RuntimeException cause)
    | JavaCompilation(str message, int line, int column, str source, list[loc] classpath)
    | MalFormedURI(str uri)
    | ModuleNotFound(str name)                 // Deprecated
    | MultipleKey(value key, value first, value second)
    | NoMainFunction()
    | NoParent(loc location)
    | NoSuchAnnotation(str label)
    | NoSuchElement(value v)
    | NoSuchField(str name)
    | NoSuchKey(value key)
    | NotImplemented(str message)
    | ParseError(loc location)
     // add versions of ParseError
    | PathNotFound(loc location)          
    | PathNotFound(set[loc] locs)
    | PermissionDenied()
    | PermissionDenied(str message)
    | RegExpSyntaxError(str message)
    | SchemeNotSupported(loc location)
    | StackOverflow()          
    | Timeout()
    | UnavailableInformation()
  	;
