/*
 * Copyright (c) 2025, Swat.engineering
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.rascalmpl.util.maven;

import java.net.http.HttpClient;

import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.settings.Server;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Class repsonsible for creating repository downloaders based on the type of repository (determined by the schema of their url).
 */
public class RepositoryDownloaderFactory {
    private HttpClient client;
    
    public RepositoryDownloaderFactory(HttpClient client) {
        this.client = client;
    }

    public RepositoryDownloader createDownloader(Repo repo, @Nullable Server server) throws InvalidRepositoryException {
        if (repo.getUrl().startsWith("file:")) {
            return new FileRepositoryDownloader(repo);
        } else if (repo.getUrl().startsWith("http:") || repo.getUrl().startsWith("https:")) {
            return new HttpRepositoryDownloader(repo, server, client);
        }

        throw new InvalidRepositoryException("Unsupported repository URL: " + repo.getUrl(), repo.getMavenRepository());
    }
}
