/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadPool {
    private DaemonThreadPool() {
    }

    public static ExecutorService buildConstrainedCached(String name, int maxThreads) {
        if (maxThreads <= 0) {
            throw new IllegalArgumentException("maxThreads should be higher than 0");
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), DaemonThreadPool.buildFactory(name));
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private static ThreadFactory buildFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger id = new AtomicInteger(0);
            private final ThreadGroup group = new ThreadGroup(name);

            @Override
            public Thread newThread(Runnable r) {
                Thread t2 = new Thread(this.group, r, name + "-" + this.id.getAndIncrement());
                t2.setDaemon(true);
                return t2;
            }
        };
    }
}

