/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch;

import engineering.swat.watch.ActiveWatch;
import engineering.swat.watch.Approximation;
import engineering.swat.watch.DaemonThreadPool;
import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchEventListener;
import engineering.swat.watch.WatchScope;
import engineering.swat.watch.impl.EventHandlingWatch;
import engineering.swat.watch.impl.jdk.JDKDirectoryWatch;
import engineering.swat.watch.impl.jdk.JDKFileTreeWatch;
import engineering.swat.watch.impl.jdk.JDKFileWatch;
import engineering.swat.watch.impl.overflows.IndexingRescanner;
import engineering.swat.watch.impl.overflows.MemorylessRescanner;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class Watch {
    private final Logger logger = LogManager.getLogger();
    private final Path path;
    private final WatchScope scope;
    private volatile Approximation approximateOnOverflow = Approximation.ALL;
    private static final Executor FALLBACK_EXECUTOR = DaemonThreadPool.buildConstrainedCached("JavaWatch-internal-handler", Runtime.getRuntime().availableProcessors());
    private volatile @MonotonicNonNull Executor executor = null;
    private static final BiConsumer<EventHandlingWatch, WatchEvent> EMPTY_HANDLER = (w, e) -> {};
    private volatile BiConsumer<EventHandlingWatch, WatchEvent> eventHandler = EMPTY_HANDLER;
    private static final Predicate<WatchEvent> TRUE_FILTER = e -> true;
    private volatile Predicate<WatchEvent> eventFilter = TRUE_FILTER;

    private Watch(Path path, WatchScope scope) {
        this.path = path;
        this.scope = scope;
    }

    public static Watch build(Path path, WatchScope scope) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("We can only watch absolute paths");
        }
        return new Watch(path, scope);
    }

    public Watch on(Consumer<WatchEvent> eventHandler) {
        if (this.eventHandler != EMPTY_HANDLER) {
            throw new IllegalArgumentException("on handler cannot be set more than once");
        }
        this.eventHandler = (w, e) -> eventHandler.accept((WatchEvent)e);
        return this;
    }

    public Watch on(WatchEventListener listener) {
        if (this.eventHandler != EMPTY_HANDLER) {
            throw new IllegalArgumentException("on handler cannot be set more than once");
        }
        this.eventHandler = (w, ev) -> {
            switch (ev.getKind()) {
                case CREATED: {
                    listener.onCreated((WatchEvent)ev);
                    break;
                }
                case DELETED: {
                    listener.onDeleted((WatchEvent)ev);
                    break;
                }
                case MODIFIED: {
                    listener.onModified((WatchEvent)ev);
                    break;
                }
                case OVERFLOW: {
                    listener.onOverflow((WatchEvent)ev);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected kind: " + String.valueOf((Object)ev.getKind()));
                }
            }
        };
        return this;
    }

    Watch filter(Predicate<WatchEvent> predicate) {
        if (this.eventFilter != TRUE_FILTER) {
            throw new IllegalArgumentException("filter cannot be set more than once");
        }
        this.eventFilter = predicate;
        return this;
    }

    public Watch withExecutor(Executor callbackHandler) {
        if (callbackHandler == null) {
            throw new IllegalArgumentException("null is allowed");
        }
        this.executor = callbackHandler;
        return this;
    }

    public Watch onOverflow(Approximation whichFiles) {
        this.approximateOnOverflow = whichFiles;
        return this;
    }

    private void validateOptions() throws IOException {
        if (this.eventHandler == EMPTY_HANDLER) {
            throw new IllegalStateException("There is no `on` handler defined");
        }
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new NoSuchFileException(this.path.toString(), null, "Cannot open a watch on a non-existing path");
        }
        switch (this.scope) {
            case PATH_AND_CHILDREN: 
            case PATH_AND_ALL_DESCENDANTS: {
                if (Files.isDirectory(this.path, LinkOption.NOFOLLOW_LINKS)) break;
                throw new FileSystemException(this.path.toString(), null, "Only directories are supported for this scope: " + String.valueOf((Object)this.scope));
            }
            case PATH_ONLY: {
                if (!Files.isSymbolicLink(this.path)) break;
                throw new FileSystemException(this.path.toString(), null, "Symlinks are not supported");
            }
            default: {
                throw new IllegalArgumentException("Unsupported scope: " + String.valueOf((Object)this.scope));
            }
        }
    }

    public ActiveWatch start() throws IOException {
        this.validateOptions();
        Executor executor = this.executor;
        if (executor == null) {
            executor = FALLBACK_EXECUTOR;
        }
        BiConsumer<EventHandlingWatch, WatchEvent> h2 = this.applyApproximateOnOverflow(executor);
        switch (this.scope) {
            case PATH_AND_CHILDREN: {
                JDKDirectoryWatch result = new JDKDirectoryWatch(this.path, executor, h2, this.eventFilter);
                result.open();
                return result;
            }
            case PATH_AND_ALL_DESCENDANTS: {
                try {
                    JDKDirectoryWatch result = new JDKDirectoryWatch(this.path, executor, h2, this.eventFilter, true);
                    result.open();
                    return result;
                }
                catch (Throwable ex) {
                    this.logger.debug("Not possible to register the native watcher, using fallback for {}", (Object)this.path);
                    this.logger.trace(ex);
                    JDKFileTreeWatch result = new JDKFileTreeWatch(this.path, executor, h2, this.eventFilter);
                    result.open();
                    return result;
                }
            }
            case PATH_ONLY: {
                JDKFileWatch result = new JDKFileWatch(this.path, executor, h2, this.eventFilter);
                result.open();
                return result;
            }
        }
        throw new IllegalStateException("Not supported yet");
    }

    private BiConsumer<EventHandlingWatch, WatchEvent> applyApproximateOnOverflow(Executor executor) {
        switch (this.approximateOnOverflow) {
            case NONE: {
                return this.eventHandler;
            }
            case ALL: {
                return this.eventHandler.andThen(new MemorylessRescanner(executor));
            }
            case DIFF: {
                return this.eventHandler.andThen(new IndexingRescanner(executor, this.path, this.scope));
            }
        }
        throw new UnsupportedOperationException("No event handler has been defined yet for this overflow policy");
    }
}

