/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.jdk;

import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchScope;
import engineering.swat.watch.impl.EventHandlingWatch;
import engineering.swat.watch.impl.jdk.JDKBaseWatch;
import engineering.swat.watch.impl.jdk.JDKPoller;
import engineering.swat.watch.impl.util.BundledSubscription;
import engineering.swat.watch.impl.util.SubscriptionKey;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class JDKDirectoryWatch
extends JDKBaseWatch {
    private final Logger logger = LogManager.getLogger();
    private final boolean nativeRecursive;
    private volatile @MonotonicNonNull Closeable bundledJDKWatcher;
    private volatile boolean closed = false;
    private static final BundledSubscription<SubscriptionKey, List<java.nio.file.WatchEvent<?>>> BUNDLED_JDK_WATCHERS = new BundledSubscription(JDKPoller::register);

    public JDKDirectoryWatch(Path directory, Executor exec, BiConsumer<EventHandlingWatch, WatchEvent> eventHandler, Predicate<WatchEvent> eventFilter) {
        this(directory, exec, eventHandler, eventFilter, false);
    }

    public JDKDirectoryWatch(Path directory, Executor exec, BiConsumer<EventHandlingWatch, WatchEvent> eventHandler, Predicate<WatchEvent> eventFilter, boolean nativeRecursive) {
        super(directory, exec, eventHandler, eventFilter);
        this.nativeRecursive = nativeRecursive;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void handleJDKEvents(List<java.nio.file.WatchEvent<?>> events) {
        this.exec.execute(() -> {
            for (java.nio.file.WatchEvent ev : events) {
                try {
                    this.handleEvent(this.translate(ev));
                }
                catch (Throwable ignored) {
                    this.logger.error("Ignoring downstream exception:", ignored);
                }
            }
        });
    }

    @Override
    public WatchScope getScope() {
        return this.nativeRecursive ? WatchScope.PATH_AND_ALL_DESCENDANTS : WatchScope.PATH_AND_CHILDREN;
    }

    @Override
    public void handleEvent(WatchEvent e) {
        if (!this.closed) {
            super.handleEvent(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed && this.bundledJDKWatcher != null) {
            this.logger.trace("Closing watch for: {}", (Object)this.path);
            this.closed = true;
            this.bundledJDKWatcher.close();
        }
    }

    @Override
    protected synchronized void start() throws IOException {
        assert (this.bundledJDKWatcher == null);
        SubscriptionKey key = new SubscriptionKey(this.path, this.nativeRecursive);
        this.bundledJDKWatcher = BUNDLED_JDK_WATCHERS.subscribe(key, this::handleJDKEvents);
    }
}

