/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.jdk;

import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchScope;
import engineering.swat.watch.impl.EventHandlingWatch;
import engineering.swat.watch.impl.jdk.JDKBaseWatch;
import engineering.swat.watch.impl.jdk.JDKDirectoryWatch;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JDKFileWatch
extends JDKBaseWatch {
    private final Logger logger = LogManager.getLogger();
    private final JDKBaseWatch internal;

    public JDKFileWatch(Path file, Executor exec, BiConsumer<EventHandlingWatch, WatchEvent> eventHandler, Predicate<WatchEvent> eventFilter) {
        super(file, exec, eventHandler, eventFilter);
        String message = "The root path is not a valid path for a file watch";
        Path parent = JDKFileWatch.requireNonNull(file.getParent(), message);
        Path fileName = JDKFileWatch.requireNonNull(file.getFileName(), message);
        assert (!parent.equals(file));
        this.internal = new JDKDirectoryWatch(parent, exec, (w, e) -> {
            WatchEvent.Kind kind = e.getKind();
            if (kind == WatchEvent.Kind.OVERFLOW || e.getRelativePath().equals(fileName)) {
                eventHandler.accept((EventHandlingWatch)w, new WatchEvent(kind, file));
            }
        }, eventFilter);
        this.logger.debug("File watch (for: {}) is in reality a directory watch (for: {}) with a filter (for: {})", (Object)file, (Object)parent, (Object)fileName);
    }

    private static Path requireNonNull(@Nullable Path p, String message) {
        if (p == null) {
            throw new IllegalArgumentException(message);
        }
        return p;
    }

    @Override
    public WatchScope getScope() {
        return WatchScope.PATH_ONLY;
    }

    @Override
    public void handleEvent(WatchEvent event) {
        this.internal.handleEvent(event);
    }

    @Override
    public synchronized void close() throws IOException {
        this.internal.close();
    }

    @Override
    protected synchronized void start() throws IOException {
        this.internal.open();
    }
}

