/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.jdk;

import com.sun.nio.file.ExtendedWatchEventModifier;
import engineering.swat.watch.DaemonThreadPool;
import engineering.swat.watch.impl.mac.MacWatchService;
import engineering.swat.watch.impl.mac.NativeLibrary;
import engineering.swat.watch.impl.util.SubscriptionKey;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class JDKPoller {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<WatchKey, Consumer<List<WatchEvent<?>>>> watchers = new ConcurrentHashMap();
    private static final WatchService service;
    private static final ExecutorService registerPool;

    private JDKPoller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void poll() {
        try {
            WatchKey hit;
            while ((hit = service.poll()) != null) {
                logger.trace("Got hit: {}", (Object)hit);
                try {
                    Consumer<List<WatchEvent<?>>> watchHandler = watchers.get(hit);
                    if (watchHandler == null) continue;
                    List<WatchEvent<?>> events = hit.pollEvents();
                    logger.trace("Found watcher for hit: {}, sending: {} (size: {})", (Object)watchHandler, (Object)events, (Object)events.size());
                    watchHandler.accept(events);
                }
                catch (Throwable t2) {
                    logger.catching(Level.INFO, t2);
                }
                finally {
                    hit.reset();
                }
            }
        }
        finally {
            CompletableFuture.delayedExecutor(1L, TimeUnit.MILLISECONDS).execute(JDKPoller::poll);
        }
    }

    public static Closeable register(final SubscriptionKey path, Consumer<List<WatchEvent<?>>> changesHandler) throws IOException {
        logger.debug("Register watch for: {}", (Object)path);
        try {
            return (Closeable)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    Watchable watchable = Platform.get().newWatchable(path.getPath());
                    WatchEvent.Kind[] kinds = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_DELETE};
                    if (path.isRecursive()) {
                        return watchable.register(service, kinds, ExtendedWatchEventModifier.FILE_TREE);
                    }
                    return watchable.register(service, kinds);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, registerPool).thenApplyAsync(key -> {
                watchers.put((WatchKey)key, changesHandler);
                return new Closeable((WatchKey)key, changesHandler){
                    final /* synthetic */ WatchKey val$key;
                    final /* synthetic */ Consumer val$changesHandler;
                    {
                        this.val$key = watchKey;
                        this.val$changesHandler = consumer;
                    }

                    @Override
                    public void close() throws IOException {
                        logger.debug("Closing watch for: {}", (Object)path);
                        if (watchers.remove(this.val$key, this.val$changesHandler)) {
                            this.val$key.cancel();
                        }
                    }
                };
            })).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException && e.getCause().getCause() instanceof IOException) {
                throw (IOException)e.getCause().getCause();
            }
            throw new IOException("Could not register path", e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("The registration was canceled");
        }
    }

    static {
        registerPool = DaemonThreadPool.buildConstrainedCached("JavaWatch-rate-limit-registry", Runtime.getRuntime().availableProcessors());
        try {
            service = Platform.get().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start watcher", e);
        }
        JDKPoller.poll();
    }

    private static interface Platform {
        public static final Platform MAC = new Platform(){

            @Override
            public WatchService newWatchService() throws IOException {
                return new MacWatchService();
            }

            @Override
            public Watchable newWatchable(Path path) {
                return MacWatchService.newWatchable(path);
            }
        };
        public static final Platform DEFAULT = new Platform(){

            @Override
            public WatchService newWatchService() throws IOException {
                return FileSystems.getDefault().newWatchService();
            }

            @Override
            public Watchable newWatchable(Path path) {
                return path;
            }
        };
        public static final Platform CURRENT = Platform.current();

        public WatchService newWatchService() throws IOException;

        public Watchable newWatchable(Path var1);

        private static Platform current() {
            if (NativeLibrary.isMac()) {
                String key = "engineering.swat.java-watch.mac";
                String val = System.getProperty(key);
                if (val != null) {
                    if (val.equals("fsevents")) {
                        return MAC;
                    }
                    if (val.equals("jdk")) {
                        return DEFAULT;
                    }
                    logger.warn("Unexpected value \"{}\" for system property \"{}\". Using value \"jdk\" instead.", (Object)val, (Object)key);
                    return DEFAULT;
                }
                return MAC;
            }
            return DEFAULT;
        }

        public static Platform get() {
            return CURRENT;
        }
    }
}

