/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.mac;

import com.sun.nio.file.ExtendedWatchEventModifier;
import engineering.swat.watch.impl.mac.MacWatchService;
import engineering.swat.watch.impl.mac.MacWatchable;
import engineering.swat.watch.impl.mac.NativeEventHandler;
import engineering.swat.watch.impl.mac.NativeEventStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.checkerframework.checker.nullness.qual.Nullable;

class MacWatchKey
implements WatchKey {
    private final MacWatchable watchable;
    private final MacWatchService service;
    private final PendingEvents pendingEvents;
    private final NativeEventStream stream;
    private volatile Configuration config = new Configuration();
    private volatile boolean cancelled = false;

    MacWatchKey(MacWatchable watchable, MacWatchService service) throws IOException {
        this.watchable = watchable;
        this.service = service;
        this.pendingEvents = new PendingEvents();
        this.stream = new NativeEventStream(watchable.getPath(), new OfferWatchEvent());
    }

    MacWatchKey initialize(WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) throws IOException {
        if (this.isValid()) {
            this.config = new Configuration(kinds, modifiers);
            this.stream.open();
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return !this.cancelled && !this.service.isClosed();
    }

    @Override
    public List<WatchEvent<?>> pollEvents() {
        return this.pendingEvents.drain();
    }

    @Override
    public boolean reset() {
        if (!this.isValid()) {
            return false;
        }
        this.pendingEvents.resignalIfNonEmpty();
        return true;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.watchable.unregister(this.service);
        this.stream.close();
    }

    @Override
    public Watchable watchable() {
        return this.watchable;
    }

    private static class Configuration {
        private final WatchEvent.Kind<?>[] kinds;
        private final boolean watchFileTree;

        public Configuration() {
            this(new WatchEvent.Kind[0], new WatchEvent.Modifier[0]);
        }

        public Configuration(WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) {
            boolean watchFileTree = false;
            for (WatchEvent.Modifier m4 : modifiers) {
                watchFileTree |= m4 == ExtendedWatchEventModifier.FILE_TREE;
            }
            this.kinds = Arrays.copyOf(kinds, kinds.length);
            this.watchFileTree = watchFileTree;
        }

        public boolean ignore(WatchEvent.Kind<?> kind, @Nullable Object context) {
            for (WatchEvent.Kind<?> k : this.kinds) {
                if (k != kind) continue;
                if (this.watchFileTree) {
                    return false;
                }
                return context instanceof Path && ((Path)context).getNameCount() > 1;
            }
            return true;
        }
    }

    private class OfferWatchEvent
    implements NativeEventHandler {
        private OfferWatchEvent() {
        }

        @Override
        public <T> void handle(final WatchEvent.Kind<T> kind, final T context) {
            if (!MacWatchKey.this.cancelled && !MacWatchKey.this.config.ignore(kind, context)) {
                WatchEvent event = new WatchEvent<T>(){

                    @Override
                    public WatchEvent.Kind<T> kind() {
                        return kind;
                    }

                    @Override
                    public int count() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public T context() {
                        return context;
                    }
                };
                MacWatchKey.this.pendingEvents.offerAndSignal(event);
            }
        }
    }

    private class PendingEvents {
        private final BlockingQueue<WatchEvent<?>> pendingEvents = new LinkedBlockingQueue();
        private volatile boolean signalled = false;

        private PendingEvents() {
        }

        void offerAndSignal(WatchEvent<?> event) {
            this.pendingEvents.offer(event);
            if (!this.signalled) {
                this.signalled = true;
                MacWatchKey.this.service.offer(MacWatchKey.this);
            }
        }

        List<WatchEvent<?>> drain() {
            ArrayList list = new ArrayList(this.pendingEvents.size());
            this.pendingEvents.drainTo(list);
            return list;
        }

        void resignalIfNonEmpty() {
            if (this.signalled && !this.pendingEvents.isEmpty()) {
                MacWatchKey.this.service.offer(MacWatchKey.this);
            } else {
                this.signalled = false;
            }
        }
    }
}

