/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.mac;

import engineering.swat.watch.impl.mac.MacWatchKey;
import engineering.swat.watch.impl.mac.MacWatchable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MacWatchService
implements WatchService {
    final BlockingQueue<MacWatchKey> pendingKeys = new LinkedBlockingQueue<MacWatchKey>();
    volatile boolean closed = false;

    boolean offer(MacWatchKey key) {
        return this.pendingKeys.offer(key);
    }

    boolean isClosed() {
        return this.closed;
    }

    public static MacWatchable newWatchable(Path path) {
        return new MacWatchable(path);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public @Nullable WatchKey poll() {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        return (WatchKey)this.pendingKeys.poll();
    }

    @Override
    public @Nullable WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey take() throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

