/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.mac;

import engineering.swat.watch.impl.mac.NativeEventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class NativeLibrary {
    private static volatile boolean loaded = false;
    private static FileAttribute<Set<PosixFilePermission>> PRIVATE_FILE = PosixFilePermissions.asFileAttribute(Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));

    public static native long start(String var0, NativeEventHandler var1);

    public static native void stop(long var0);

    public static boolean isMac() {
        String os = System.getProperty("os.name");
        return os != null && (os.toLowerCase().contains("mac") || os.toLowerCase().contains("darwin"));
    }

    private static boolean isAarch64() {
        String arch = System.getProperty("os.arch");
        return arch != null && arch.toLowerCase().equals("aarch64");
    }

    public static void load() {
        if (loaded) {
            return;
        }
        try {
            if (!NativeLibrary.isMac()) {
                throw new IllegalStateException("We should not be loading FileSystemEvents api on non mac machines");
            }
            Object path = "/engineering/swat/watch/jni/";
            path = NativeLibrary.isAarch64() ? (String)path + "macos-aarch64/" : (String)path + "macos-x64/";
            path = (String)path + "librust_fsevents_jni.dylib";
            NativeLibrary.loadLibrary((String)path);
        }
        finally {
            loaded = true;
        }
    }

    private static OutputStream openPrivateStream(Path forFile, OpenOption ... flags) throws IOException {
        return Channels.newOutputStream(Files.newByteChannel(forFile, Set.of(flags), PRIVATE_FILE));
    }

    private static void loadLibrary(String path) {
        block14: {
            try {
                Path localCopy = Files.createTempFile("watch", ".dylib", PRIVATE_FILE);
                localCopy.toFile().deleteOnExit();
                try (InputStream libStream = NativeLibrary.class.getResourceAsStream(path);){
                    if (libStream == null) break block14;
                    try (OutputStream writer = NativeLibrary.openPrivateStream(localCopy, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                        libStream.transferTo(writer);
                    }
                    System.load(localCopy.toString());
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException("We could not load: " + path, e);
            }
        }
    }
}

