/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.overflows;

import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchScope;
import engineering.swat.watch.impl.EventHandlingWatch;
import engineering.swat.watch.impl.overflows.BaseFileVisitor;
import engineering.swat.watch.impl.overflows.MemorylessRescanner;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IndexingRescanner
extends MemorylessRescanner {
    private final Logger logger = LogManager.getLogger();
    private final PathMap<FileTime> index = new PathMap();

    public IndexingRescanner(Executor exec, Path path, WatchScope scope) {
        super(exec);
        new Indexer(path, scope).walkFileTree();
    }

    @Override
    protected MemorylessRescanner.Generator newGenerator(Path path, WatchScope scope) {
        return new Generator(path, scope);
    }

    @Override
    public void accept(EventHandlingWatch watch, WatchEvent event) {
        super.accept(watch, event);
        WatchEvent.Kind kind = event.getKind();
        Path fullPath = event.calculateFullPath();
        switch (kind) {
            case CREATED: 
            case MODIFIED: {
                try {
                    FileTime lastModifiedTimeNew = Files.getLastModifiedTime(fullPath, new LinkOption[0]);
                    FileTime lastModifiedTimeOld = this.index.put(fullPath, lastModifiedTimeNew);
                    if (lastModifiedTimeOld != null || kind != WatchEvent.Kind.MODIFIED) break;
                    WatchEvent created = new WatchEvent(WatchEvent.Kind.CREATED, fullPath);
                    watch.handleEvent(watch.relativize(created));
                }
                catch (IOException e) {
                    if (!Files.exists(fullPath, new LinkOption[0])) break;
                    this.logger.error("Could not get modification time of: {} ({})", (Object)fullPath, (Object)e);
                }
                break;
            }
            case DELETED: {
                this.index.remove(fullPath);
                break;
            }
        }
    }

    protected class Generator
    extends MemorylessRescanner.Generator {
        private final Deque<Set<Path>> visited;

        public Generator(Path path, WatchScope scope) {
            super(IndexingRescanner.this, path, scope);
            this.visited = new ArrayDeque<Set<Path>>();
            this.visited.push(new HashSet());
        }

        private void addToPeeked(Deque<Set<Path>> deque, Path p) {
            Set<Path> peeked = deque.peek();
            Path fileName = p.getFileName();
            if (peeked != null && fileName != null) {
                peeked.add(fileName);
            }
        }

        @Override
        protected void generateEvents(Path path, BasicFileAttributes attrs) {
            FileTime lastModifiedTimeOld = IndexingRescanner.this.index.get(path);
            FileTime lastModifiedTimeNew = attrs.lastModifiedTime();
            if (lastModifiedTimeOld == null) {
                super.generateEvents(path, attrs);
            } else if (lastModifiedTimeOld.compareTo(lastModifiedTimeNew) < 0) {
                this.events.add(new WatchEvent(WatchEvent.Kind.MODIFIED, path));
            }
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.addToPeeked(this.visited, dir);
            this.visited.push(new HashSet());
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.addToPeeked(this.visited, file);
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Set<Path> visitedInDir = this.visited.pop();
            if (visitedInDir != null) {
                for (Path p : IndexingRescanner.this.index.getFileNames(dir)) {
                    Path fullPath;
                    if (visitedInDir.contains(p) || Files.exists(fullPath = dir.resolve(p), new LinkOption[0])) continue;
                    this.events.add(new WatchEvent(WatchEvent.Kind.DELETED, fullPath));
                }
            }
            return super.postVisitDirectory(dir, exc);
        }
    }

    private class Indexer
    extends BaseFileVisitor {
        public Indexer(Path path, WatchScope scope) {
            super(path, scope);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!this.path.equals(dir)) {
                IndexingRescanner.this.index.put(dir, attrs.lastModifiedTime());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            IndexingRescanner.this.index.put(file, attrs.lastModifiedTime());
            return FileVisitResult.CONTINUE;
        }
    }

    private static class PathMap<V> {
        private final Map<Path, Map<Path, V>> values = new ConcurrentHashMap<Path, Map<Path, V>>();

        private PathMap() {
        }

        public @Nullable V put(Path p, V value) {
            return PathMap.apply(this.put(value), p);
        }

        public @Nullable V get(Path p) {
            return (V)PathMap.apply(this::get, p);
        }

        public Set<Path> getParents() {
            return this.values.keySet();
        }

        public Set<Path> getFileNames(Path parent) {
            Map<Path, V> inner = this.values.get(parent);
            return inner == null ? Collections.emptySet() : inner.keySet();
        }

        public @Nullable V remove(Path p) {
            return (V)PathMap.apply(this::remove, p);
        }

        private static <V> V apply(BiFunction<Path, Path, V> action, Path p) {
            Path parent = p.getParent();
            Path fileName = p.getFileName();
            if (parent != null && fileName != null) {
                return action.apply(parent, fileName);
            }
            throw new IllegalArgumentException("The path should have both a parent and a file name");
        }

        private BiFunction<Path, Path, @Nullable V> put(V value) {
            return (parent, fileName) -> this.put((Path)parent, (Path)fileName, value);
        }

        private @Nullable V put(Path parent, Path fileName, V value) {
            Map inner = this.values.computeIfAbsent(parent, x -> new ConcurrentHashMap());
            V previous = inner.put(fileName, value);
            if (this.values.get(parent) != inner) {
                previous = this.put(parent, fileName, value);
            }
            return previous;
        }

        private @Nullable V get(Path parent, Path fileName) {
            Map<Path, V> inner = this.values.get(parent);
            return inner == null ? null : (V)inner.get(fileName);
        }

        private @Nullable V remove(Path parent, Path fileName) {
            Map<Path, V> inner = this.values.get(parent);
            if (inner != null) {
                V removed = inner.remove(fileName);
                if (inner.isEmpty() && this.values.remove(parent, inner) && !inner.isEmpty()) {
                    for (Map.Entry<Path, V> e : inner.entrySet()) {
                        this.put(parent, e.getKey(), e.getValue());
                    }
                }
                return removed;
            }
            return null;
        }
    }
}

