/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public interface IMap
extends ICollection<IMap> {
    @Override
    default public int getMatchFingerprint() {
        return 107868;
    }

    default public IMap put(IValue key, IValue value) {
        IMapWriter sw = this.writer();
        sw.putAll(this);
        sw.put(key, value);
        return (IMap)sw.done();
    }

    public IMap removeKey(IValue var1);

    @Pure
    public @Nullable IValue get(IValue var1);

    @EnsuresNonNullIf(expression={"get(#1)"}, result=true)
    public boolean containsKey(IValue var1);

    @EqualsMethod
    default public boolean defaultEquals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof IMap) {
            IMap map2 = (IMap)other;
            if (this.getType() != map2.getType()) {
                return false;
            }
            if (this.hashCode() != map2.hashCode()) {
                return false;
            }
            if (this.size() == map2.size()) {
                block0: for (IValue k1 : map2) {
                    for (IValue cursor : this) {
                        if (!cursor.equals(k1)) continue;
                        IValue val2 = map2.get(k1);
                        if (val2 == null || val2.equals(this.get(k1))) continue block0;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    default public int defaultHashCode() {
        int hash = 0;
        for (IValue key : this) {
            hash ^= key.hashCode();
        }
        return hash;
    }

    @Override
    default public boolean match(IValue other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IMap) {
            IMap map2 = (IMap)other;
            if (this.size() == map2.size()) {
                block0: for (IValue k1 : this) {
                    IValue v1 = this.get(k1);
                    if (!1.$assertionsDisabled && v1 == null) {
                        throw new AssertionError((Object)"@AssumeAssertion(nullness)");
                    }
                    for (IValue k2 : map2) {
                        if (!k2.match(k1)) continue;
                        IValue v2 = map2.get(k2);
                        if (v2 != null && v2.match(v1)) continue block0;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    default public boolean containsValue(IValue value) {
        for (IValue elem : () -> this.valueIterator()) {
            if (!elem.equals(value)) continue;
            return true;
        }
        return false;
    }

    default public Type getKeyType() {
        return this.getType().getKeyType();
    }

    default public Type getValueType() {
        return this.getType().getValueType();
    }

    default public IMap join(IMap other) {
        IMapWriter sw = this.writer();
        sw.putAll(this);
        sw.putAll(other);
        return (IMap)sw.done();
    }

    default public IMap remove(IMap other) {
        IMapWriter sw = this.writer();
        for (Map.Entry entry : () -> this.entryIterator()) {
            if (other.containsKey((IValue)entry.getKey())) continue;
            sw.put((IValue)entry.getKey(), (IValue)entry.getValue());
        }
        return (IMap)sw.done();
    }

    default public IMap compose(IMap other) {
        IMapWriter w = this.writer();
        for (Map.Entry e : () -> this.entryIterator()) {
            IValue value = other.get((IValue)e.getValue());
            if (value == null) continue;
            w.put((IValue)e.getKey(), value);
        }
        return (IMap)w.done();
    }

    public IMapWriter writer();

    default public IMap common(IMap other) {
        IMapWriter sw = this.writer();
        for (Map.Entry entry : () -> this.entryIterator()) {
            IValue thisKey = (IValue)entry.getKey();
            IValue thisValue = (IValue)entry.getValue();
            IValue otherValue = other.get(thisKey);
            if (otherValue == null || !thisValue.equals(otherValue)) continue;
            sw.put(thisKey, thisValue);
        }
        return (IMap)sw.done();
    }

    default public boolean isSubMap(IMap other) {
        for (Map.Entry entry : () -> this.entryIterator()) {
            IValue key = (IValue)entry.getKey();
            if (!other.containsKey(key)) {
                return false;
            }
            if (other.get(key).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<IValue> iterator();

    public Iterator<IValue> valueIterator();

    public Iterator<Map.Entry<IValue, IValue>> entryIterator();

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitMap(this);
    }

    @Override
    public Stream<IValue> stream();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

