/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.ListRelation;
import io.usethesource.vallang.impl.persistent.ListWriter;
import io.usethesource.vallang.impl.persistent.SubList;
import io.usethesource.vallang.impl.util.collections.ShareableValuesList;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

class List
implements IList {
    protected static final TypeFactory typeFactory = TypeFactory.getInstance();
    protected static final Type voidType = typeFactory.voidType();
    protected final Type listType;
    protected final ShareableValuesList data;
    protected int hashCode = -1;

    static IList newList(Type elementType, ShareableValuesList data) {
        return new List(elementType, data);
    }

    private List(Type elementType, ShareableValuesList data) {
        this.listType = typeFactory.listType(elementType);
        this.data = data;
    }

    @Override
    public IRelation<IList> asRelation() {
        return new ListRelation(this);
    }

    @Override
    public IListWriter writer() {
        return new ListWriter();
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public Type getType() {
        return this.listType;
    }

    @Override
    public int length() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public IValue get(int index) {
        return (IValue)this.data.get(index);
    }

    @Override
    public boolean contains(IValue element) {
        return this.data.contains(element);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.data.iterator();
    }

    @Override
    public IList append(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.append(element);
        Type newElementType = this.getType().getElementType().lub(element.getType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList concat(IList other) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        Iterator otherIterator = other.iterator();
        while (otherIterator.hasNext()) {
            newData.append((IValue)otherIterator.next());
        }
        Type newElementType = this.getType().getElementType().lub(other.getElementType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList insert(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.insert(element);
        Type newElementType = this.getType().getElementType().lub(element.getType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList put(int index, IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.set(index, element);
        Type newElementType = this.getType().getElementType().lub(element.getType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList delete(int index) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.remove(index);
        Type newElementType = TypeFactory.getInstance().voidType();
        for (IValue el : newData) {
            newElementType = newElementType.lub(el.getType());
        }
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList delete(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        if (newData.remove(element)) {
            Type newElementType = TypeFactory.getInstance().voidType();
            for (IValue el : newData) {
                newElementType = newElementType.lub(el.getType());
            }
            return new ListWriter(newElementType, newData).done();
        }
        return this;
    }

    @Override
    public IList reverse() {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.reverse();
        return new ListWriter(this.getType().getElementType(), newData).done();
    }

    @Override
    public IList shuffle(Random rand) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        for (int i = newData.size() - 1; i >= 1; --i) {
            newData.set(i, newData.set(rand.nextInt(i + 1), (IValue)newData.get(i)));
        }
        return new ListWriter(this.getType().getElementType(), newData).done();
    }

    @Override
    public IList sublist(int offset, int length) {
        if (length < 4) {
            return this.materializedSublist(offset, length);
        }
        return new SubList(this, offset, length);
    }

    IList materializedSublist(int offset, int length) {
        ShareableValuesList newData = this.data.subList(offset, length);
        Type oldElementType = this.getType().getElementType();
        Type newElementType = TypeFactory.getInstance().voidType();
        for (IValue el : newData) {
            if (newElementType == oldElementType) break;
            newElementType = newElementType.lub(el.getType());
        }
        return new ListWriter(newElementType, newData).done();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.data.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof IList) {
            IList otherList = (IList)o;
            if (this.getType() != otherList.getType()) {
                return false;
            }
            if (otherList instanceof List) {
                List oList = (List)o;
                if (this.hashCode() != oList.hashCode()) {
                    return false;
                }
                return this.data.equals(oList.data);
            }
            return this.defaultEquals(otherList);
        }
        return false;
    }
}

