/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.capsule.Map;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.persistent.MapWriter;
import io.usethesource.vallang.impl.persistent.Tuple;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.util.AbstractTypeBag;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PersistentHashMap
implements IMap {
    private @MonotonicNonNull Type cachedMapType;
    private final AbstractTypeBag keyTypeBag;
    private final AbstractTypeBag valTypeBag;
    private final Map.Immutable<@NonNull IValue, @NonNull IValue> content;

    protected PersistentHashMap(AbstractTypeBag keyTypeBag, AbstractTypeBag valTypeBag, Map.Immutable<@NonNull IValue, @NonNull IValue> content) {
        this.keyTypeBag = keyTypeBag;
        this.valTypeBag = valTypeBag;
        this.content = content;
        assert (content.size() == keyTypeBag.sum());
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    @Override
    public Type getType() {
        if (this.cachedMapType == null) {
            this.cachedMapType = TF.mapType(this.keyTypeBag.lub(), this.valTypeBag.lub());
        }
        return this.cachedMapType;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public IMap put(IValue key, IValue value) {
        AbstractTypeBag valBagNew;
        AbstractTypeBag keyBagNew;
        Map.Immutable<IValue, IValue> contentNew = this.content.__put(key, value);
        if (this.content == contentNew) {
            return this;
        }
        if (this.content.size() == contentNew.size()) {
            IValue replaced = (IValue)this.content.get(key);
            keyBagNew = this.keyTypeBag;
            valBagNew = this.valTypeBag.decrease(replaced.getType()).increase(value.getType());
        } else {
            keyBagNew = this.keyTypeBag.increase(key.getType());
            valBagNew = this.valTypeBag.increase(value.getType());
        }
        return new PersistentHashMap(keyBagNew, valBagNew, contentNew);
    }

    @Override
    public IMap removeKey(IValue key) {
        Map.Immutable<IValue, IValue> newContent = this.content.__remove(key);
        if (newContent == this.content) {
            return this;
        }
        IValue removedValue = (IValue)this.content.get(key);
        AbstractTypeBag newKeyBag = this.keyTypeBag.decrease(key.getType());
        AbstractTypeBag newValBag = this.valTypeBag.decrease(removedValue.getType());
        assert (!newContent.isEmpty() || newKeyBag.lub().isBottom() && newValBag.lub().isBottom());
        return new PersistentHashMap(newKeyBag, newValBag, newContent);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    @EnsuresNonNullIf(expression={"get(#1)"}, result=true)
    public boolean containsKey(IValue key) {
        return this.content.containsKey(key);
    }

    @Override
    public boolean containsValue(IValue value) {
        return this.content.containsValue(value);
    }

    @Override
    public IValue get(IValue key) {
        return (IValue)this.content.get(key);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PersistentHashMap) {
            PersistentHashMap that = (PersistentHashMap)other;
            if (this.getType() != that.getType()) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            return this.content.equals(that.content);
        }
        if (other instanceof IMap) {
            return this.defaultEquals(other);
        }
        return false;
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.keyIterator();
    }

    @Override
    public Iterator<IValue> valueIterator() {
        return this.content.valueIterator();
    }

    @Override
    public Iterator<Map.Entry<IValue, IValue>> entryIterator() {
        return this.content.entryIterator();
    }

    @Override
    public IMap join(IMap other) {
        if (other instanceof PersistentHashMap) {
            PersistentHashMap that = (PersistentHashMap)other;
            Map.Transient<IValue, IValue> transientContent = this.content.asTransient();
            boolean isModified = false;
            int previousSize = this.size();
            AbstractTypeBag keyBagNew = this.keyTypeBag;
            AbstractTypeBag valBagNew = this.valTypeBag;
            Iterator<Map.Entry<IValue, IValue>> it = that.entryIterator();
            while (it.hasNext()) {
                IValue value;
                Map.Entry<IValue, IValue> tuple = it.next();
                IValue key = tuple.getKey();
                IValue replaced = transientContent.__put(key, value = tuple.getValue());
                if (replaced != null) {
                    valBagNew = valBagNew.decrease(replaced.getType()).increase(value.getType());
                    isModified = true;
                    continue;
                }
                if (previousSize == transientContent.size()) continue;
                keyBagNew = keyBagNew.increase(key.getType());
                valBagNew = valBagNew.increase(value.getType());
                isModified = true;
                ++previousSize;
            }
            if (isModified) {
                return new PersistentHashMap(keyBagNew, valBagNew, transientContent.freeze());
            }
            return this;
        }
        return IMap.super.join(other);
    }

    @Override
    public Type getElementType() {
        return this.keyTypeBag.lub();
    }

    @Override
    public IMap empty() {
        return (IMap)this.writer().done();
    }

    @Override
    public IMapWriter writer() {
        return new MapWriter();
    }

    @Override
    public Stream<IValue> stream() {
        return StreamSupport.stream(this.spliterator(), false).map(key -> Tuple.newTuple(key, this.get((IValue)key)));
    }

    @Override
    public IRelation<IMap> asRelation() {
        throw new UnsupportedOperationException();
    }
}

