/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.impl.primitive.AbstractNumberValue;
import io.usethesource.vallang.impl.primitive.BoolValue;
import io.usethesource.vallang.impl.primitive.IntegerValue;
import io.usethesource.vallang.impl.util.BigDecimalCalculations;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.Nullable;

class BigDecimalValue
extends AbstractNumberValue
implements IReal {
    private static final Type DOUBLE_TYPE = TypeFactory.getInstance().realType();
    protected final BigDecimal value;

    static IReal newReal(BigDecimal value) {
        return new BigDecimalValue(value);
    }

    static IReal newReal(String value) {
        return new BigDecimalValue(new BigDecimal(value));
    }

    static IReal newReal(String value, int precision) throws NumberFormatException {
        return new BigDecimalValue(new BigDecimal(value, new MathContext(precision)));
    }

    static IReal newReal(double value) {
        BigDecimalValue.checkNanAndInfinity(value);
        return new BigDecimalValue(BigDecimal.valueOf(value));
    }

    public static void checkNanAndInfinity(double value) {
        if (Double.isNaN(value)) {
            throw new NumberFormatException("no support for NaN");
        }
        if (Double.isInfinite(value)) {
            throw new NumberFormatException("no support for infinity");
        }
    }

    static IReal newReal(double value, int precision) {
        BigDecimalValue.checkNanAndInfinity(value);
        return new BigDecimalValue(new BigDecimal(value, new MathContext(precision)));
    }

    private BigDecimalValue(BigDecimal value) {
        this.value = value;
    }

    private BigDecimalValue(BigDecimal value, int precision) {
        this.value = new BigDecimal(value.toEngineeringString(), new MathContext(precision));
    }

    @Override
    public IReal abs() {
        return BigDecimalValue.newReal(this.value.abs());
    }

    @Override
    public IReal toReal(int precision) {
        return this;
    }

    @Override
    public Type getType() {
        return DOUBLE_TYPE;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public IInteger toInteger() {
        return IntegerValue.newInteger(this.value.toBigInteger());
    }

    @Override
    public IRational toRational() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReal floor() {
        return BigDecimalValue.newReal(this.value.setScale(0, RoundingMode.FLOOR));
    }

    @Override
    public IReal round() {
        return BigDecimalValue.newReal(this.value.setScale(0, RoundingMode.HALF_UP));
    }

    @Override
    public IReal add(IReal other) {
        return BigDecimalValue.newReal(this.value.add(((BigDecimalValue)other).value));
    }

    @Override
    public INumber add(IInteger other) {
        return this.add(other.toReal(this.value.precision()));
    }

    @Override
    public INumber add(IRational other) {
        return this.add(other.toReal(this.value.precision()));
    }

    @Override
    public IReal subtract(IReal other) {
        return BigDecimalValue.newReal(this.value.subtract(((BigDecimalValue)other).value));
    }

    @Override
    public INumber subtract(IInteger other) {
        return this.subtract(other.toReal(this.value.precision()));
    }

    @Override
    public INumber subtract(IRational other) {
        return this.subtract(other.toReal(this.value.precision()));
    }

    @Override
    public IReal multiply(IReal other) {
        return BigDecimalValue.newReal(this.value.multiply(((BigDecimalValue)other).value));
    }

    @Override
    public INumber multiply(IInteger other) {
        return this.multiply(other.toReal(this.value.precision()));
    }

    @Override
    public INumber multiply(IRational other) {
        return this.multiply(other.toReal(this.value.precision()));
    }

    @Override
    public IReal divide(IReal other, int precision) {
        precision = Math.max(Math.max(this.value.precision(), other.precision()), precision);
        MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
        return BigDecimalValue.newReal(this.value.divide(((BigDecimalValue)other).value, mc));
    }

    @Override
    public IReal divide(IInteger other, int precision) {
        return this.divide(other.toReal(precision), precision);
    }

    @Override
    public IReal divide(IRational other, int precision) {
        return this.divide(other.toReal(precision), precision);
    }

    @Override
    public IReal negate() {
        return BigDecimalValue.newReal(this.value.negate());
    }

    @Override
    public int precision() {
        return this.value.precision();
    }

    @Override
    public int scale() {
        return this.value.scale();
    }

    @Override
    public IInteger unscaled() {
        return IntegerValue.newInteger(this.value.unscaledValue());
    }

    @Override
    public IBool equal(IReal other) {
        return BoolValue.getBoolValue(this.compare(other) == 0);
    }

    @Override
    public IBool equal(IInteger other) {
        return this.equal(other.toReal(this.value.precision()));
    }

    @Override
    public IBool equal(IRational other) {
        return this.equal(other.toReal(this.value.precision()));
    }

    @Override
    public IBool greater(IReal other) {
        return BoolValue.getBoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greater(IInteger other) {
        return this.greater(other.toReal(this.value.precision()));
    }

    @Override
    public IBool greater(IRational other) {
        return this.greater(other.toReal(this.value.precision()));
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return BoolValue.getBoolValue(this.compare(other) >= 0);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return this.greaterEqual(other.toReal(this.value.precision()));
    }

    @Override
    public IBool greaterEqual(IRational other) {
        return this.greaterEqual(other.toReal(this.value.precision()));
    }

    @Override
    public IBool less(IReal other) {
        return BoolValue.getBoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool less(IInteger other) {
        return this.less(other.toReal(this.value.precision()));
    }

    @Override
    public IBool less(IRational other) {
        return this.less(other.toReal(this.value.precision()));
    }

    @Override
    public IBool lessEqual(IReal other) {
        return BoolValue.getBoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return this.lessEqual(other.toReal(this.value.precision()));
    }

    @Override
    public IBool lessEqual(IRational other) {
        return this.lessEqual(other.toReal(this.value.precision()));
    }

    @Override
    public int compare(IReal other) {
        return this.value.compareTo(((BigDecimalValue)other).value);
    }

    @Override
    public int compare(INumber other) {
        return this.compare(other.toReal(this.value.precision()));
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value.doubleValue());
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            BigDecimalValue otherDouble = (BigDecimalValue)o;
            return this.value.equals(otherDouble.value);
        }
        return false;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        String decimalString = this.value.toString();
        sb.append(decimalString);
        if (!decimalString.matches(".*[\\.Ee].*")) {
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public IReal log(IInteger base, int precision) {
        return this.log(base.toReal(precision), precision);
    }

    @Override
    public IReal log(IReal base, int precision) {
        IReal lnBase = base.ln(precision + 1);
        IReal lnThis = this.ln(precision + 1);
        return lnThis.divide(lnBase, precision);
    }

    @Override
    public IReal ln(int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.ln(this.value, precision));
    }

    @Override
    public IReal sqrt(int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.sqrt(this.value, precision));
    }

    @Override
    public IReal nroot(IInteger n, int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.intRoot(this.value, new BigInteger(n.getTwosComplementRepresentation()), precision));
    }

    @Override
    public IReal exp(int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.exp(this.value, precision));
    }

    @Override
    public IReal pow(IInteger power) {
        if (power.signum() < 0) {
            return BigDecimalValue.newReal(BigDecimal.ONE.divide(this.value.pow(power.negate().intValue()), this.value.precision(), RoundingMode.HALF_EVEN));
        }
        return BigDecimalValue.newReal(this.value.pow(power.intValue()));
    }

    @Override
    public IReal pow(IReal power, int precision) {
        BigDecimal actualPower = null;
        actualPower = power instanceof BigDecimalValue ? ((BigDecimalValue)power).value : new BigDecimal(power.getStringRepresentation());
        return BigDecimalValue.newReal(BigDecimalCalculations.pow(this.value, actualPower, precision));
    }

    @Override
    public IReal tan(int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.tan(this.value, precision));
    }

    @Override
    public IReal sin(int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.sin(this.value, precision));
    }

    @Override
    public IReal cos(int precision) {
        return BigDecimalValue.newReal(BigDecimalCalculations.cos(this.value, precision));
    }

    public static IReal pi(int precision) {
        if (precision < 0 || precision > 1000) {
            throw new IllegalArgumentException("PI max precision is 1000");
        }
        return BigDecimalValue.newReal(BigDecimalCalculations.PI.setScale(precision, RoundingMode.HALF_EVEN));
    }

    public static IReal e(int precision) {
        if (precision < 0 || precision > 1000) {
            throw new IllegalArgumentException("E max precision is 1000");
        }
        return BigDecimalValue.newReal(BigDecimalCalculations.E.setScale(precision, RoundingMode.HALF_EVEN));
    }
}

