/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.primitive;

import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.exceptions.InvalidDateTimeException;
import io.usethesource.vallang.impl.primitive.StringValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

class DateTimeValues {
    private static final Type DATE_TIME_TYPE = TypeFactory.getInstance().dateTimeType();

    DateTimeValues() {
    }

    static IDateTime newDate(int year, int month, int day) {
        return new DateValue(year, month, day);
    }

    static IDateTime newTime(int hour, int minute, int second, int millisecond) {
        return new TimeValue(hour, minute, second, millisecond);
    }

    static IDateTime newTime(int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        return new TimeValue(hour, minute, second, millisecond, hourOffset, minuteOffset);
    }

    private static long currentTotalOffset() {
        return OffsetDateTime.now().getOffset().getTotalSeconds();
    }

    private static int currentHourOffset() {
        return (int)TimeUnit.HOURS.convert(DateTimeValues.currentTotalOffset(), TimeUnit.SECONDS);
    }

    private static int currentMinuteOffset() {
        return (int)(TimeUnit.MINUTES.convert(DateTimeValues.currentTotalOffset(), TimeUnit.SECONDS) % 60L);
    }

    private static ZoneOffset toOffset(int hourOffset, int minuteOffset) {
        return ZoneOffset.ofHoursMinutes(hourOffset, minuteOffset);
    }

    static IDateTime newDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new DateTimeValue(year, month, day, hour, minute, second, millisecond);
    }

    static IDateTime newDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        return new DateTimeValue(year, month, day, hour, minute, second, millisecond, hourOffset, minuteOffset);
    }

    static IDateTime newDateTime(long instant) {
        return new DateTimeValue(instant, 0, 0);
    }

    static IDateTime newDateTime(long instant, int timezoneHours, int timezoneMinutes) {
        return new DateTimeValue(instant, timezoneHours, timezoneMinutes);
    }

    private static class DateTimeValue
    implements IDateTime {
        private final OffsetDateTime actual;

        private DateTimeValue(int year, int month, int day, int hour, int minute, int second, int millisecond) {
            this(year, month, day, hour, minute, second, millisecond, DateTimeValues.currentHourOffset(), DateTimeValues.currentMinuteOffset());
        }

        private DateTimeValue(int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
            try {
                this.actual = OffsetDateTime.of(year, month, day, hour, minute, second, (int)TimeUnit.MILLISECONDS.toNanos(millisecond), DateTimeValues.toOffset(hourOffset, minuteOffset));
            }
            catch (DateTimeException dt) {
                throw new InvalidDateTimeException("Cannot create date with provided values.", dt);
            }
        }

        private DateTimeValue(long instant, int timezoneHours, int timezoneMinutes) {
            try {
                this.actual = Instant.ofEpochMilli(instant).atOffset(DateTimeValues.toOffset(timezoneHours, timezoneMinutes));
            }
            catch (DateTimeException dt) {
                throw new InvalidDateTimeException("Cannot create date with provided values.", dt);
            }
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public Type getType() {
            return DATE_TIME_TYPE;
        }

        @Override
        public int compareTo(IDateTime arg0) {
            if (arg0 instanceof DateTimeValue) {
                return this.actual.compareTo(((DateTimeValue)arg0).actual);
            }
            if (arg0.isDateTime()) {
                return Long.compare(this.getInstant(), arg0.getInstant());
            }
            throw new UnsupportedOperationException("DateTime and non-DateTime values are not comparable");
        }

        @Override
        public long getInstant() {
            return this.actual.toInstant().toEpochMilli();
        }

        @Override
        public int getCentury() {
            return (this.getYear() - this.getYear() % 100) / 100;
        }

        @Override
        public int getYear() {
            return this.actual.getYear();
        }

        @Override
        public int getMonthOfYear() {
            return this.actual.getMonthValue();
        }

        @Override
        public int getDayOfMonth() {
            return this.actual.getDayOfMonth();
        }

        @Override
        public int getHourOfDay() {
            return this.actual.getHour();
        }

        @Override
        public int getMinuteOfHour() {
            return this.actual.getMinute();
        }

        @Override
        public int getSecondOfMinute() {
            return this.actual.getSecond();
        }

        @Override
        public int getMillisecondsOfSecond() {
            return (int)TimeUnit.MILLISECONDS.convert(this.actual.getNano(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int getTimezoneOffsetHours() {
            return (int)TimeUnit.HOURS.convert(this.actual.getOffset().getTotalSeconds(), TimeUnit.SECONDS);
        }

        @Override
        public int getTimezoneOffsetMinutes() {
            return (int)(TimeUnit.MINUTES.convert(this.actual.getOffset().getTotalSeconds(), TimeUnit.SECONDS) % 60L);
        }

        @Override
        public boolean isDate() {
            return false;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public boolean isDateTime() {
            return true;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof DateTimeValue) {
                return this.actual.equals(((DateTimeValue)obj).actual);
            }
            return false;
        }

        @Override
        public IString format(String format) {
            return StringValue.newString(this.actual.format(DateTimeFormatter.ofPattern(format)));
        }
    }

    private static class TimeValue
    implements IDateTime {
        private final OffsetTime actual;

        private TimeValue(int hour, int minute, int second, int millisecond) {
            this(hour, minute, second, millisecond, DateTimeValues.currentHourOffset(), DateTimeValues.currentMinuteOffset());
        }

        private TimeValue(int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
            try {
                this.actual = OffsetTime.of(hour, minute, second, (int)TimeUnit.MILLISECONDS.toNanos(millisecond), DateTimeValues.toOffset(hourOffset, minuteOffset));
            }
            catch (DateTimeException dt) {
                throw new InvalidDateTimeException("Cannot create date with provided values.", dt);
            }
        }

        @Override
        public Type getType() {
            return DATE_TIME_TYPE;
        }

        @Override
        public int compareTo(IDateTime arg0) {
            if (arg0 instanceof TimeValue) {
                return this.actual.compareTo(((TimeValue)arg0).actual);
            }
            if (arg0.isTime()) {
                return Long.compare(this.getInstant(), arg0.getInstant());
            }
            throw new UnsupportedOperationException("Time and non-Time values are not comparable");
        }

        @Override
        public long getInstant() {
            return this.actual.atDate(LocalDate.of(1970, 1, 1)).toInstant().toEpochMilli();
        }

        @Override
        public int getCentury() {
            throw new UnsupportedOperationException("Cannot get century on a time value");
        }

        @Override
        public int getYear() {
            throw new UnsupportedOperationException("Cannot get year on a time value");
        }

        @Override
        public int getMonthOfYear() {
            throw new UnsupportedOperationException("Cannot get month on a time value");
        }

        @Override
        public int getDayOfMonth() {
            throw new UnsupportedOperationException("Cannot get day on a time value");
        }

        @Override
        public int getHourOfDay() {
            return this.actual.getHour();
        }

        @Override
        public int getMinuteOfHour() {
            return this.actual.getMinute();
        }

        @Override
        public int getSecondOfMinute() {
            return this.actual.getSecond();
        }

        @Override
        public int getMillisecondsOfSecond() {
            return (int)TimeUnit.MILLISECONDS.convert(this.actual.getNano(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int getTimezoneOffsetHours() {
            return (int)TimeUnit.HOURS.convert(this.actual.getOffset().getTotalSeconds(), TimeUnit.SECONDS);
        }

        @Override
        public int getTimezoneOffsetMinutes() {
            return (int)(TimeUnit.MINUTES.convert(this.actual.getOffset().getTotalSeconds(), TimeUnit.SECONDS) % 60L);
        }

        @Override
        public boolean isDate() {
            return false;
        }

        @Override
        public boolean isTime() {
            return true;
        }

        @Override
        public boolean isDateTime() {
            return false;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof TimeValue) {
                return this.actual.equals(((TimeValue)obj).actual);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public IString format(String format) {
            return StringValue.newString(this.actual.format(DateTimeFormatter.ofPattern(format)));
        }
    }

    private static class DateValue
    implements IDateTime {
        private final LocalDate actual;

        private DateValue(int year, int month, int day) {
            try {
                this.actual = LocalDate.of(year, month, day);
            }
            catch (DateTimeException dt) {
                throw new InvalidDateTimeException("Cannot create date with provided values.", dt);
            }
        }

        @Override
        public Type getType() {
            return DATE_TIME_TYPE;
        }

        @Override
        public int compareTo(IDateTime arg0) {
            if (arg0 instanceof DateValue) {
                return this.actual.compareTo(((DateValue)arg0).actual);
            }
            if (arg0.isDate()) {
                return Long.compare(this.getInstant(), arg0.getInstant());
            }
            throw new UnsupportedOperationException("Date and non-Date values are not comparable");
        }

        @Override
        public long getInstant() {
            return this.actual.atTime(LocalTime.MIN).atZone(ZoneId.systemDefault()).toEpochSecond() * 1000L;
        }

        @Override
        public int getCentury() {
            return (this.getYear() - this.getYear() % 100) / 100;
        }

        @Override
        public int getYear() {
            return this.actual.getYear();
        }

        @Override
        public int getMonthOfYear() {
            return this.actual.getMonthValue();
        }

        @Override
        public int getDayOfMonth() {
            return this.actual.getDayOfMonth();
        }

        @Override
        public int getHourOfDay() {
            throw new UnsupportedOperationException("Cannot get hours on a date value");
        }

        @Override
        public int getMinuteOfHour() {
            throw new UnsupportedOperationException("Cannot get minutes on a date value");
        }

        @Override
        public int getSecondOfMinute() {
            throw new UnsupportedOperationException("Cannot get seconds on a date value");
        }

        @Override
        public int getMillisecondsOfSecond() {
            throw new UnsupportedOperationException("Cannot get milliseconds on a date value");
        }

        @Override
        public int getTimezoneOffsetHours() {
            throw new UnsupportedOperationException("Cannot get timezone offset hours on a date value");
        }

        @Override
        public int getTimezoneOffsetMinutes() {
            throw new UnsupportedOperationException("Cannot get timezone offset minutes on a date value");
        }

        @Override
        public boolean isDate() {
            return true;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public boolean isDateTime() {
            return false;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof DateValue) {
                return ((DateValue)obj).actual.equals(this.actual);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.defaultToString();
        }

        @Override
        public IString format(String format) {
            return StringValue.newString(this.actual.format(DateTimeFormatter.ofPattern(format)));
        }
    }
}

