/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.UnexpectedChildTypeException;
import io.usethesource.vallang.impl.fields.AbstractDefaultWithKeywordParameters;
import io.usethesource.vallang.impl.fields.ConstructorWithKeywordParametersFacade;
import io.usethesource.vallang.impl.reference.Node;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Constructor
extends Node
implements IConstructor {
    Constructor(Type type, IValue[] children) {
        super(type.getName(), type, children);
        assert (!type.getAbstractDataType().isParameterized() || type.getAbstractDataType().isOpen());
    }

    Constructor(Type type) {
        this(type, new IValue[0]);
    }

    private Constructor(Constructor other, int childIndex, IValue newChild) {
        super(other, childIndex, newChild);
    }

    @Override
    public Type getType() {
        return this.getConstructorType().getAbstractDataType();
    }

    @Override
    public Type getUninstantiatedConstructorType() {
        return this.fType;
    }

    @Override
    public Type getConstructorType() {
        if (this.fType.getAbstractDataType().isParameterized()) {
            assert (this.fType.getAbstractDataType().isOpen());
            Type[] actualTypes = new Type[this.fChildren.length];
            for (int i = 0; i < this.fChildren.length; ++i) {
                actualTypes[i] = this.fChildren[i].getType();
            }
            HashMap<Type, Type> bindings = new HashMap<Type, Type>();
            this.fType.getFieldTypes().match(TypeFactory.getInstance().tupleType(actualTypes), bindings);
            for (Type field : this.fType.getAbstractDataType().getTypeParameters()) {
                if (bindings.containsKey(field)) continue;
                bindings.put(field, TypeFactory.getInstance().voidType());
            }
            return this.fType.instantiate(bindings);
        }
        return this.fType;
    }

    @Override
    public IValue get(String label) {
        return super.get(this.fType.getFieldIndex(label));
    }

    @Override
    public Type getChildrenTypes() {
        return this.fType.getFieldTypes();
    }

    @Override
    public IConstructor set(int i, IValue newChild) throws IndexOutOfBoundsException {
        this.checkChildType(i, newChild);
        return new Constructor(this, i, newChild);
    }

    @Override
    public IConstructor set(String label, IValue newChild) throws FactTypeUseException {
        int childIndex = this.fType.getFieldIndex(label);
        this.checkChildType(childIndex, newChild);
        return new Constructor(this, childIndex, newChild);
    }

    private void checkChildType(int i, IValue newChild) {
        Type expectedType;
        Type type = newChild.getType();
        if (!type.isSubtypeOf(expectedType = this.getConstructorType().getFieldType(i))) {
            throw new UnexpectedChildTypeException(expectedType, type);
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Constructor other = (Constructor)obj;
            return this.fType == other.fType && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 + ~super.hashCode();
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitConstructor(this);
    }

    @Override
    public boolean has(String label) {
        return this.getConstructorType().hasField(label);
    }

    @Override
    public boolean mayHaveKeywordParameters() {
        return true;
    }

    public IWithKeywordParameters<IConstructor> asWithKeywordParameters() {
        return new AbstractDefaultWithKeywordParameters<IConstructor>((IConstructor)this, AbstractSpecialisedImmutableMap.mapOf()){

            @Override
            protected IConstructor wrap(IConstructor content, Map.Immutable<String, IValue> parameters) {
                return new ConstructorWithKeywordParametersFacade(content, parameters);
            }

            @Override
            public boolean hasParameters() {
                return this.parameters != null && this.parameters.size() > 0;
            }

            @Override
            public Set<String> getParameterNames() {
                return Collections.unmodifiableSet(this.parameters.keySet());
            }

            @Override
            public Map<String, IValue> getParameters() {
                return Collections.unmodifiableMap(this.parameters);
            }
        };
    }
}

