/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IRelation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.reference.MapWriter;
import io.usethesource.vallang.impl.reference.Tuple;
import io.usethesource.vallang.type.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

class Map
implements IMap {
    final Type type;
    final java.util.Map<IValue, IValue> content;

    Map(Type candidateMapType, java.util.Map<IValue, IValue> content) {
        this.content = content;
        this.type = candidateMapType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public boolean containsKey(IValue key) {
        return this.content.containsKey(key);
    }

    @Override
    public IMap removeKey(IValue key) {
        IMapWriter w = this.writer();
        for (Map.Entry cursor : this::entryIterator) {
            if (((IValue)cursor.getKey()).equals(key)) continue;
            w.put((IValue)cursor.getKey(), (IValue)cursor.getValue());
        }
        return (IMap)w.done();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    @Pure
    public @Nullable IValue get(IValue key) {
        return this.content.get(key);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.content.keySet().iterator();
    }

    @Override
    public Iterator<IValue> valueIterator() {
        return this.content.values().iterator();
    }

    @Override
    public Iterator<Map.Entry<IValue, IValue>> entryIterator() {
        return this.content.entrySet().iterator();
    }

    @Override
    public Type getElementType() {
        return this.type.getKeyType();
    }

    @Override
    public IMap empty() {
        return (IMap)this.writer().done();
    }

    @Override
    public IMapWriter writer() {
        return new MapWriter();
    }

    @Override
    public IRelation<IMap> asRelation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        return this.defaultEquals(obj);
    }

    @Override
    public Stream<IValue> stream() {
        Iterable it = this::entryIterator;
        return StreamSupport.stream(it.spliterator(), false).map(entry -> new Tuple((IValue)entry.getKey(), (IValue)entry.getValue()));
    }
}

