/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactParseError;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.OverloadingNotSupportedException;
import io.usethesource.vallang.exceptions.UnexpectedTypeException;
import io.usethesource.vallang.io.AbstractTextReader;
import io.usethesource.vallang.type.ExternalType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StandardTextReader
extends AbstractTextReader {
    @Override
    public IValue read(IValueFactory factory, TypeStore store, Type type, Reader stream) throws FactTypeUseException, IOException {
        return new TextReader(factory, store, stream).read(type);
    }

    private static class TextReader {
        private static final char START_OF_LOC = '|';
        private static final char START_OF_STRING = '\"';
        private static final char END_OF_STRING = '\"';
        private static final char START_OF_MAP = '(';
        private static final char START_OF_ARGUMENTS = '(';
        private static final char END_OF_ARGUMENTS = ')';
        private static final char START_OF_TUPLE = '<';
        private static final char START_OF_SET = '{';
        private static final char START_OF_LIST = '[';
        private static final char END_OF_TUPLE = '>';
        private static final char COMMA_SEPARATOR = ',';
        private static final char END_OF_MAP = ')';
        private static final char DOUBLE_DOT = '.';
        private static final char RATIONAL_SEP = 'r';
        private static final char END_OF_SET = '}';
        private static final char END_OF_LIST = ']';
        private static final char END_OF_LOCATION = '|';
        private static final char START_OF_DATETIME = '$';
        private static final char END_OF_DATETIME = '$';
        private static final char NEGATIVE_SIGN = '-';
        private static final TypeFactory types = TypeFactory.getInstance();
        private final TypeStore store;
        private final NoWhiteSpaceReader stream;
        private final IValueFactory factory;
        private int current;
        private Cache<String, ISourceLocation> sourceLocationCache;
        private static final TypeFactory TF = TypeFactory.getInstance();
        private static final Type generalMapType = TF.mapType(TF.valueType(), TF.valueType());
        private static final Type genericSetType = TF.setType(TF.valueType());
        private static final Type genericListType = TF.listType(TF.valueType());

        public TextReader(IValueFactory factory, TypeStore store, Reader stream) {
            this.store = store;
            this.stream = new NoWhiteSpaceReader(stream);
            this.factory = factory;
            this.sourceLocationCache = Caffeine.newBuilder().maximumSize(1000L).build();
        }

        public IValue read(Type expected) throws IOException {
            this.current = this.stream.read();
            IValue result = this.readValue(expected);
            if (this.current != -1 || this.stream.read() != -1) {
                throw this.unexpectedException();
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private IValue readValue(Type expected) throws IOException {
            IValue result = null;
            if (Character.isDigit(this.current) || this.current == 46 || this.current == 45) {
                result = this.readNumber(expected);
            } else if (Character.isJavaIdentifierStart(this.current) && 36 != this.current || this.current == 92) {
                boolean escaped = this.current == 92;
                String id = this.readIdentifier();
                if (!escaped && id.equals("true") && !expected.isAbstractData()) {
                    return this.factory.bool(true);
                }
                if (!escaped && id.equals("false") && !expected.isAbstractData()) {
                    return this.factory.bool(false);
                }
                if (this.current == 61) {
                    return this.factory.string(id);
                }
                if (this.current != 40) throw new FactParseError("expected = or (", this.stream.offset);
                result = this.readConstructor(id, expected);
            } else {
                switch (this.current) {
                    case 34: {
                        result = this.readString(expected);
                        break;
                    }
                    case 91: {
                        result = this.readList(expected);
                        break;
                    }
                    case 123: {
                        result = this.readSet(expected);
                        break;
                    }
                    case 60: {
                        result = this.readTuple(expected);
                        break;
                    }
                    case 40: {
                        result = this.readMap(expected);
                        break;
                    }
                    case 124: {
                        result = this.readLocation(expected);
                        break;
                    }
                    case 36: {
                        result = this.readDateTime(expected);
                        break;
                    }
                    default: {
                        throw this.unexpectedException();
                    }
                }
            }
            assert (result != null) : "@AssumeAssertion(nullness)";
            if (!result.getType().isSubtypeOf(expected)) {
                throw new UnexpectedTypeException(expected, result.getType());
            }
            if (this.current != 91) return result;
            if (!result.getType().isSubtypeOf(types.nodeType())) throw this.unexpectedException(93);
            return this.readAnnos(expected, (INode)result);
        }

        private IValue readLocation(Type expected) throws IOException {
            try {
                String url = this.parseURL();
                ISourceLocation loc = this.getCachedLocation(url);
                if (this.current == 40) {
                    ArrayList<IValue> args = new ArrayList<IValue>(4);
                    this.readFixed(types.valueType(), ')', args, Collections.emptyMap());
                    if (args.size() >= 2) {
                        if (!args.get(0).getType().isSubtypeOf(types.integerType())) {
                            throw new UnexpectedTypeException(types.integerType(), args.get(0).getType());
                        }
                        if (!args.get(1).getType().isSubtypeOf(types.integerType())) {
                            throw new UnexpectedTypeException(types.integerType(), args.get(1).getType());
                        }
                        Type posType = types.tupleType(types.integerType(), types.integerType());
                        if (args.size() == 4) {
                            if (!args.get(2).getType().isSubtypeOf(posType)) {
                                throw new UnexpectedTypeException(posType, args.get(2).getType());
                            }
                            if (!args.get(3).getType().isSubtypeOf(posType)) {
                                throw new UnexpectedTypeException(posType, args.get(3).getType());
                            }
                        }
                        int offset = Integer.parseInt(args.get(0).toString());
                        int length = Integer.parseInt(args.get(1).toString());
                        if (args.size() == 4) {
                            int beginLine = Integer.parseInt(((ITuple)args.get(2)).get(0).toString());
                            int beginColumn = Integer.parseInt(((ITuple)args.get(2)).get(1).toString());
                            int endLine = Integer.parseInt(((ITuple)args.get(3)).get(0).toString());
                            int endColumn = Integer.parseInt(((ITuple)args.get(3)).get(1).toString());
                            return this.factory.sourceLocation(loc, offset, length, beginLine, endLine, beginColumn, endColumn);
                        }
                        if (args.size() != 2) {
                            throw new FactParseError("source locations should have either 2 or 4 arguments", offset);
                        }
                        return this.factory.sourceLocation(loc, offset, length);
                    }
                }
                return loc;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof URISyntaxException) {
                    URISyntaxException actual = (URISyntaxException)e.getCause();
                    throw new FactParseError(actual.getMessage(), this.stream.offset, actual);
                }
                throw e;
            }
        }

        private ISourceLocation getCachedLocation(String url) {
            assert (this.sourceLocationCache != null) : "@AssumeAssertion(nullness)";
            ISourceLocation loc = this.sourceLocationCache.get(url, u -> {
                try {
                    return this.factory.sourceLocation(new URI((String)u));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            });
            assert (loc != null) : "@AssumeAssertion(nullness)";
            return loc;
        }

        private String parseURL() throws IOException {
            this.current = this.stream.read();
            StringBuilder result = new StringBuilder();
            while (this.current != 124) {
                result.append((char)this.current);
                this.current = this.stream.read();
                if (this.current != -1) continue;
                throw this.unexpectedException();
            }
            this.current = this.stream.read();
            return result.toString();
        }

        private IValue readMap(Type expected) throws IOException {
            Type keyType = expected.isSubtypeOf(generalMapType) ? expected.getKeyType() : types.valueType();
            Type valueType = expected.isSubtypeOf(generalMapType) ? expected.getValueType() : types.valueType();
            IMapWriter w = this.factory.mapWriter();
            this.checkAndRead('(');
            while (this.current != 41) {
                IValue key = this.readValue(keyType);
                this.checkAndRead(':');
                IValue value = this.readValue(valueType);
                w.put(key, value);
                if (this.current != 44 || this.current == 41) break;
                this.checkAndRead(',');
            }
            this.checkAndRead(')');
            return w.done();
        }

        private IValue readTuple(Type expected) throws IOException {
            ArrayList<IValue> arr = new ArrayList<IValue>();
            this.readFixed(expected, '>', arr, Collections.emptyMap());
            IValue[] result = arr.toArray(new IValue[0]);
            return this.factory.tuple(result);
        }

        private IValue readSet(Type expected) throws FactTypeUseException, IOException {
            Type elemType = expected.isSubtypeOf(genericSetType) ? expected.getElementType() : types.valueType();
            return this.readContainer(elemType, this.factory.setWriter(), '}');
        }

        private IValue readList(Type expected) throws FactTypeUseException, IOException {
            Type elemType = expected.isSubtypeOf(genericListType) ? expected.getElementType() : types.valueType();
            return this.readList(elemType, this.factory.listWriter(), ']');
        }

        private void checkMoreThanOnce(String input, char needle) {
            boolean first = true;
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != needle) continue;
                if (first) {
                    first = false;
                    continue;
                }
                throw new FactParseError(needle + " occured for the second time", this.stream.offset - input.length() + i);
            }
        }

        private IValue readNumber(Type expected) throws IOException {
            StringBuilder builder = new StringBuilder();
            do {
                builder.append((char)this.current);
                this.current = this.stream.read();
            } while (Character.isDigit(this.current) || this.current == 114 || this.current == 46 || this.current == 69 || this.current == 101 || this.current == 43 || this.current == 45);
            String val = builder.toString();
            this.checkMoreThanOnce(val, 'r');
            this.checkMoreThanOnce(val, '.');
            this.checkMoreThanOnce(val, 'E');
            this.checkMoreThanOnce(val, 'e');
            try {
                if (val.contains(".") || val.contains("E") || val.contains("e")) {
                    return this.factory.real(val);
                }
                return this.factory.integer(val);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return this.factory.real(val);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        return this.factory.rational(val);
                    }
                    catch (NumberFormatException numberFormatException3) {
                        throw this.unexpectedException(this.current);
                    }
                }
            }
        }

        private IValue readConstructor(String id, Type expected) throws IOException {
            ArrayList<IValue> arr = new ArrayList<IValue>();
            Type args = expected;
            Type constr = null;
            if (expected.isExternalType()) {
                expected = ((ExternalType)expected).asAbstractDataType();
            }
            if (expected.isAbstractData()) {
                Set<Type> alternatives = this.store.lookupConstructor(expected, id);
                if (alternatives.size() > 1) {
                    throw new OverloadingNotSupportedException(expected, id);
                }
                if (alternatives.size() == 0) {
                    args = types.valueType();
                } else {
                    constr = alternatives.iterator().next();
                    args = constr.getFieldTypes();
                }
            }
            HashMap<String, IValue> kwParams = new HashMap<String, IValue>();
            this.readFixed(args, ')', arr, kwParams);
            @NonNull IValue[] result = arr.toArray(new IValue[0]);
            if (expected.isTop()) {
                constr = this.store.lookupFirstConstructor(id, TF.tupleType(result));
            }
            if (constr != null) {
                return this.factory.constructor(constr, result, kwParams);
            }
            return this.factory.node(id, result, kwParams);
        }

        private boolean readAndAppendIfNumeric(StringBuilder buf) throws IOException {
            this.current = this.stream.read();
            if (Character.isDigit(this.current)) {
                buf.append((char)this.current);
                return true;
            }
            return false;
        }

        private DateParts readDate(char firstChar) throws IOException, FactParseError {
            boolean res;
            int i;
            StringBuilder buf = new StringBuilder();
            buf.append(firstChar);
            for (i = 0; i < 3; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading date, expected digit, found: " + this.current, this.stream.offset);
            }
            this.current = this.stream.read();
            if (45 != this.current) {
                throw new FactParseError("Error reading date, expected '-', found: " + this.current, this.stream.offset);
            }
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading date, expected digit, found: " + this.current, this.stream.offset);
            }
            this.current = this.stream.read();
            if (45 != this.current) {
                throw new FactParseError("Error reading date, expected '-', found: " + this.current, this.stream.offset);
            }
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading date, expected digit, found: " + this.current, this.stream.offset);
            }
            String dateString = buf.toString();
            return new DateParts(Integer.parseInt(dateString.substring(0, 4)), Integer.parseInt(dateString.substring(4, 6)), Integer.parseInt(dateString.substring(6)));
        }

        private TimeParts readTime() throws IOException, FactParseError {
            boolean res;
            int i;
            StringBuilder buf = new StringBuilder();
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
            }
            this.current = this.stream.read();
            if (58 != this.current) {
                throw new FactParseError("Error reading time, expected ':', found: " + this.current, this.stream.offset);
            }
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
            }
            this.current = this.stream.read();
            if (58 != this.current) {
                throw new FactParseError("Error reading time, expected ':', found: " + this.current, this.stream.offset);
            }
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
            }
            this.current = this.stream.read();
            if (46 != this.current) {
                throw new FactParseError("Error reading time, expected '.', found: " + this.current, this.stream.offset);
            }
            for (i = 0; i < 3; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
            }
            this.current = this.stream.read();
            if (43 != this.current && 45 != this.current) {
                throw new FactParseError("Error reading time, expected '+' or '-', found: " + this.current, this.stream.offset);
            }
            buf.append((char)this.current);
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (res) continue;
                throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
            }
            for (i = 0; i < 2; ++i) {
                res = this.readAndAppendIfNumeric(buf);
                if (this.current == 58 && i == 0) {
                    i = -1;
                    res = true;
                }
                if (res) continue;
                throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
            }
            String timeString = buf.toString();
            boolean negativeTZHours = timeString.substring(9, 10).equals("-");
            return new TimeParts(Integer.parseInt(timeString.substring(0, 2)), Integer.parseInt(timeString.substring(2, 4)), Integer.parseInt(timeString.substring(4, 6)), Integer.parseInt(timeString.substring(6, 9)), Integer.parseInt(timeString.substring(10, 12)) * (negativeTZHours ? -1 : 1), Integer.parseInt(timeString.substring(12)) * (negativeTZHours ? -1 : 1));
        }

        private IValue readDateTime(Type expected) throws IOException, FactParseError {
            DateParts dateParts = null;
            TimeParts timeParts = null;
            boolean isDate = false;
            boolean isTime = false;
            this.current = this.stream.read();
            if (84 == this.current || 116 == this.current) {
                timeParts = this.readTime();
                isTime = true;
                this.current = this.stream.read();
            } else {
                dateParts = this.readDate((char)this.current);
                this.current = this.stream.read();
                if (84 == this.current || 116 == this.current) {
                    timeParts = this.readTime();
                    this.current = this.stream.read();
                } else {
                    isDate = true;
                }
            }
            if (36 == this.current) {
                this.current = this.stream.read();
            }
            if (isDate) {
                assert (dateParts != null) : "@AssumeAssertion(nullness)";
                return this.factory.date(dateParts.getYear(), dateParts.getMonth(), dateParts.getDay());
            }
            if (isTime) {
                assert (timeParts != null) : "@AssumeAssertion(nullness)";
                return this.factory.time(timeParts.getHour(), timeParts.getMinute(), timeParts.getSecond(), timeParts.getMillisecond(), timeParts.getTimezoneHours(), timeParts.getTimezoneMinutes());
            }
            assert (dateParts != null) : "@AssumeAssertion(nullness)";
            assert (timeParts != null) : "@AssumeAssertion(nullness)";
            return this.factory.datetime(dateParts.getYear(), dateParts.getMonth(), dateParts.getDay(), timeParts.getHour(), timeParts.getMinute(), timeParts.getSecond(), timeParts.getMillisecond(), timeParts.getTimezoneHours(), timeParts.getTimezoneMinutes());
        }

        private String readIdentifier() throws IOException {
            boolean escaped;
            StringBuilder builder = new StringBuilder();
            boolean bl = escaped = this.current == 92;
            if (escaped) {
                this.current = this.stream.read();
            }
            while (Character.isJavaIdentifierStart(this.current) || Character.isJavaIdentifierPart(this.current) || escaped && this.current == 45) {
                builder.append((char)this.current);
                this.current = this.stream.read();
            }
            return builder.toString();
        }

        private IValue readString(Type expected) throws IOException {
            StringBuilder builder = new StringBuilder();
            this.current = this.stream.read();
            while (this.current != 34) {
                if (this.current == 92) {
                    this.current = this.stream.read();
                    switch (this.current) {
                        case 110: {
                            builder.append('\n');
                            break;
                        }
                        case 116: {
                            builder.append('\t');
                            break;
                        }
                        case 114: {
                            builder.append('\r');
                            break;
                        }
                        case 102: {
                            builder.append('\f');
                            break;
                        }
                        case 98: {
                            builder.append('\b');
                            break;
                        }
                        case 34: {
                            builder.append('\"');
                            break;
                        }
                        case 62: {
                            builder.append('>');
                            break;
                        }
                        case 60: {
                            builder.append('<');
                            break;
                        }
                        case 39: {
                            builder.append('\'');
                            break;
                        }
                        case 92: {
                            builder.append('\\');
                            break;
                        }
                        case 97: {
                            StringBuilder a = new StringBuilder();
                            a.append((char)this.stream.read());
                            a.append((char)this.stream.read());
                            builder.append((char)Integer.parseInt(a.toString(), 16));
                            break;
                        }
                        case 117: {
                            StringBuilder u = new StringBuilder();
                            u.append((char)this.stream.read());
                            u.append((char)this.stream.read());
                            u.append((char)this.stream.read());
                            u.append((char)this.stream.read());
                            builder.append((char)Integer.parseInt(u.toString(), 16));
                            break;
                        }
                        case 85: {
                            StringBuilder U = new StringBuilder();
                            U.append((char)this.stream.read());
                            U.append((char)this.stream.read());
                            U.append((char)this.stream.read());
                            U.append((char)this.stream.read());
                            U.append((char)this.stream.read());
                            U.append((char)this.stream.read());
                            int cp = Integer.parseInt(U.toString(), 16);
                            if (!Character.isValidCodePoint(cp)) {
                                throw new FactParseError(String.valueOf(U) + " is not a valid 24 bit Unicode character", this.stream.getOffset());
                            }
                            builder.appendCodePoint(cp);
                            break;
                        }
                        default: {
                            if (this.current == -1) {
                                throw new FactParseError("End of input before finding end of String", this.stream.offset);
                            }
                            builder.append((char)this.current);
                        }
                    }
                    this.current = this.stream.read();
                    continue;
                }
                if (this.current == -1) {
                    throw new FactParseError("End of input before finding end of String", this.stream.offset);
                }
                builder.appendCodePoint(this.current);
                this.current = this.stream.read();
            }
            String str = builder.toString();
            this.current = this.stream.read();
            if (this.current == 40) {
                ArrayList<IValue> arr = new ArrayList<IValue>();
                HashMap<String, IValue> kwParams = new HashMap<String, IValue>();
                this.readFixed(expected, ')', arr, kwParams);
                IValue[] result = arr.toArray(new IValue[0]);
                return this.factory.node(str, result, kwParams);
            }
            return this.factory.string(str);
        }

        @Deprecated
        private IValue readAnnos(Type expected, INode result) throws IOException {
            this.current = this.stream.read();
            while (this.current != 93) {
                this.checkAndRead('@');
                String key = this.readIdentifier();
                if (this.isLegacyParseTreeSourceAnnotation(key, result.getType())) {
                    key = "src";
                }
                this.checkAndRead('=');
                Type annoType = this.getAnnoType(expected, key);
                IValue value = this.readValue(annoType);
                result = result.asWithKeywordParameters().setParameter(key, value);
                if (this.current == 93) {
                    this.current = this.stream.read();
                    break;
                }
                this.checkAndRead(',');
            }
            return result;
        }

        private boolean isLegacyParseTreeSourceAnnotation(String key, Type type) {
            return key.equals("loc") && type.isAbstractData() && type.getName().equals("Tree");
        }

        private Type getAnnoType(Type expected, String key) {
            Type annoType = null;
            if (expected.isStrictSubtypeOf(TF.nodeType()) && this.store.hasKeywordParameter(expected, key)) {
                annoType = this.store.getKeywordParameterType(expected, key);
            }
            return annoType != null ? annoType : types.valueType();
        }

        private void readFixed(Type expected, char end, List<@NonNull IValue> arr, Map<String, IValue> kwParams) throws IOException {
            this.current = this.stream.read();
            int i = 0;
            while (this.current != end) {
                Type exp = expected.isFixedWidth() && i < expected.getArity() ? expected.getFieldType(i) : types.valueType();
                IValue elem = this.readValue(exp);
                if (this.current == 61) {
                    String label = ((IString)elem).getValue();
                    this.current = this.stream.read();
                    if (expected.isConstructor() && expected.hasField(label)) {
                        kwParams.put(label, this.readValue(expected.getFieldType(label)));
                    } else {
                        kwParams.put(label, this.readValue(types.valueType()));
                    }
                } else {
                    arr.add(elem);
                }
                if (this.current != 44 || this.current == end) break;
                this.current = this.stream.read();
                ++i;
            }
            this.checkAndRead(end);
        }

        private IValue readContainer(Type elemType, IWriter<?> w, char end) throws FactTypeUseException, IOException {
            this.current = this.stream.read();
            while (this.current != end) {
                w.insert(this.readValue(elemType));
                if (this.current != 44 || this.current == end) break;
                this.current = this.stream.read();
            }
            this.checkAndRead(end);
            return w.done();
        }

        private IValue readList(Type elemType, IListWriter w, char end) throws FactTypeUseException, IOException {
            this.current = this.stream.read();
            while (this.current != end) {
                w.append(this.readValue(elemType));
                if (this.current != 44 || this.current == end) break;
                this.current = this.stream.read();
            }
            this.checkAndRead(end);
            return w.done();
        }

        private void checkAndRead(char c) throws IOException {
            if (this.current != c) {
                throw this.unexpectedException(c);
            }
            this.current = this.stream.read();
        }

        private FactParseError unexpectedException(int c) {
            return new FactParseError("Expected " + (char)c + " but got " + (char)this.current, this.stream.getOffset());
        }

        private FactParseError unexpectedException() {
            return new FactParseError("Unexpected " + (char)this.current, this.stream.getOffset());
        }

        private static class TimeParts {
            private final int hour;
            private final int minute;
            private final int second;
            private final int millisecond;
            private final int timezoneHours;
            private final int timezoneMinutes;

            public TimeParts(int hour, int minute, int second, int millisecond, int timezoneHours, int timezoneMinutes) {
                this.hour = hour;
                this.minute = minute;
                this.second = second;
                this.millisecond = millisecond;
                this.timezoneHours = timezoneHours;
                this.timezoneMinutes = timezoneMinutes;
            }

            public int getHour() {
                return this.hour;
            }

            public int getMinute() {
                return this.minute;
            }

            public int getSecond() {
                return this.second;
            }

            public int getMillisecond() {
                return this.millisecond;
            }

            public int getTimezoneHours() {
                return this.timezoneHours;
            }

            public int getTimezoneMinutes() {
                return this.timezoneMinutes;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("%02d", this.hour)).append(":").append(String.format("%02d", this.minute)).append(":").append(String.format("%02d", this.second)).append(".").append(String.format("%03d", this.millisecond));
                if (this.timezoneHours < 0 || this.timezoneHours == 0 && this.timezoneMinutes < 0) {
                    sb.append("-");
                } else {
                    sb.append("+");
                }
                sb.append(String.format("%02d", Math.abs(this.timezoneHours))).append(":").append(String.format("%02d", Math.abs(this.timezoneMinutes)));
                return sb.toString();
            }
        }

        private static class DateParts {
            private final int year;
            private final int month;
            private final int day;

            public DateParts(int year, int month, int day) {
                this.year = year;
                this.month = month;
                this.day = day;
            }

            public int getYear() {
                return this.year;
            }

            public int getMonth() {
                return this.month;
            }

            public int getDay() {
                return this.day;
            }

            public String toString() {
                return String.format("%04d", this.year) + "-" + String.format("%02d", this.month) + "-" + String.format("%02d", this.day);
            }
        }

        private static class NoWhiteSpaceReader
        extends Reader {
            private Reader wrapped;
            int offset;
            boolean inString = false;
            boolean escaping = false;

            public NoWhiteSpaceReader(Reader wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int read() throws IOException {
                int r = this.wrapped.read();
                ++this.offset;
                if (!this.inString) {
                    while (Character.isWhitespace(r)) {
                        ++this.offset;
                        r = this.wrapped.read();
                    }
                }
                if (!this.inString && r == 34) {
                    this.inString = true;
                } else if (this.inString) {
                    if (this.escaping) {
                        this.escaping = false;
                    } else if (r == 92) {
                        this.escaping = true;
                    } else if (r == 34) {
                        this.inString = false;
                    }
                }
                return r;
            }

            int getOffset() {
                return this.offset;
            }

            @Override
            public void close() throws IOException {
                this.wrapped.close();
            }
        }
    }
}

