/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.UnsupportedTypeException;
import io.usethesource.vallang.io.IValueTextWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLWriter
implements IValueTextWriter {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    @Override
    public void write(IValue value, Writer stream) throws IOException {
        try {
            Document doc = dbf.newDocumentBuilder().newDocument();
            Node top = this.give(value, doc);
            doc.appendChild(top);
            Transformer t2 = TransformerFactory.newInstance().newTransformer();
            t2.setOutputProperty("indent", "yes");
            t2.transform(new DOMSource(doc), new StreamResult(stream));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("XML configuration is invalid: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException("Exception while serializing XML: " + e.getMessage());
        }
        catch (DOMException e) {
            throw new UnsupportedTypeException(e.getMessage(), value.getType());
        }
    }

    @Override
    public void write(IValue value, Writer stream, TypeStore typeStore) throws IOException {
        this.write(value, stream);
    }

    private Node give(IValue value, Document doc) {
        Type type = value.getType();
        if (type.isAbstractData()) {
            Type node = ((IConstructor)value).getConstructorType();
            if (this.isListWrapper(node)) {
                return this.giveList((INode)value, doc);
            }
            if (this.isSetWrapper(node)) {
                return this.giveSet((INode)value, doc);
            }
            if (this.isRelationWrapper(node)) {
                return this.giveRelation((INode)value, doc);
            }
            if (this.isMapWrapper(node)) {
                return this.giveMap((INode)value, doc);
            }
            return this.giveTree((INode)value, doc);
        }
        if (type.isString()) {
            return this.giveString((IString)value, doc);
        }
        if (type.isInteger()) {
            return this.giveInt((IInteger)value, doc);
        }
        if (type.isRational()) {
            return this.giveRational((IRational)value, doc);
        }
        if (type.isReal()) {
            return this.giveDouble((IReal)value, doc);
        }
        if (type.isExternalType()) {
            return this.giveExternal((IExternalValue)value, doc);
        }
        throw new UnsupportedTypeException("Outermost or nested tuples, lists, sets, relations or maps are not allowed.", type);
    }

    private boolean isListWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isList();
    }

    private boolean isSetWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isSet();
    }

    private boolean isRelationWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isRelation();
    }

    private boolean isMapWrapper(Type nodeType) {
        return nodeType.getArity() == 1 && nodeType.getFieldTypes().getFieldType(0).isMap();
    }

    private Node giveDouble(IReal value, Document doc) {
        return doc.createTextNode(value.toString());
    }

    private Node giveInt(IInteger value, Document doc) {
        return doc.createTextNode(value.toString());
    }

    private Node giveRational(IRational value, Document doc) {
        Element element = doc.createElementNS("values", "rat");
        element.setAttribute("num", value.numerator().toString());
        element.setAttribute("denom", value.denominator().toString());
        return element;
    }

    private Node giveString(IString value, Document doc) {
        return doc.createTextNode(value.getValue());
    }

    private Node giveExternal(IExternalValue value, Document doc) {
        return doc.createTextNode(value.toString());
    }

    private Node giveMap(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        IMap map = (IMap)node.get(0);
        for (Map.Entry entry : () -> map.entryIterator()) {
            IValue key = (IValue)entry.getKey();
            IValue value = (IValue)entry.getValue();
            if (key.getType().isTuple()) {
                this.appendTupleElements(doc, treeNode, key);
            } else {
                treeNode.appendChild(this.give(key, doc));
            }
            if (value.getType().isTuple()) {
                this.appendTupleElements(doc, treeNode, value);
                continue;
            }
            treeNode.appendChild(this.give(value, doc));
        }
        return treeNode;
    }

    private void appendTupleElements(Document doc, Element treeNode, IValue tupleValue) {
        ITuple tuple = (ITuple)tupleValue;
        for (IValue element : tuple) {
            treeNode.appendChild(this.give(element, doc));
        }
    }

    private Node giveRelation(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        ISet relation = (ISet)node.get(0);
        assert (relation.getType().isRelation());
        for (IValue tuple : relation) {
            this.appendTupleElements(doc, treeNode, tuple);
        }
        return treeNode;
    }

    private Node giveSet(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        ISet set = (ISet)node.get(0);
        for (IValue elem : set) {
            if (elem.getType().isTuple()) {
                this.appendTupleElements(doc, treeNode, elem);
                continue;
            }
            treeNode.appendChild(this.give(elem, doc));
        }
        return treeNode;
    }

    private Node giveList(INode node, Document doc) {
        Element treeNode = doc.createElement(node.getName());
        IList list = (IList)node.get(0);
        for (IValue elem : list) {
            if (elem.getType().isTuple()) {
                this.appendTupleElements(doc, treeNode, elem);
                continue;
            }
            treeNode.appendChild(this.give(elem, doc));
        }
        return treeNode;
    }

    private Node giveTree(INode value, Document doc) {
        Element treeNode = doc.createElement(value.getName());
        for (IValue child : value) {
            if (child.getType().isTuple()) {
                this.appendTupleElements(doc, treeNode, child);
                continue;
            }
            treeNode.appendChild(this.give(child, doc));
        }
        return treeNode;
    }
}

