/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer source;

    public ByteBuffer getByteBuffer() {
        return this.source;
    }

    public ByteBufferInputStream(ByteBuffer source) {
        this.source = source;
    }

    protected ByteBuffer refill(ByteBuffer torefill) throws IOException {
        return torefill;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= this.source.remaining()) {
            this.source.get(b, off, len);
            return len;
        }
        int read = 0;
        while (read < len) {
            int chunk = Math.min(this.source.remaining(), len - read);
            this.source.get(b, off + read, chunk);
            if ((read += chunk) >= len || this.source.hasRemaining()) continue;
            this.source = this.refill(this.source);
            if (this.source.hasRemaining()) continue;
            if (read == 0) {
                return -1;
            }
            return read;
        }
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        if (!this.source.hasRemaining()) {
            this.source = this.refill(this.source);
            if (!this.source.hasRemaining()) {
                return -1;
            }
        }
        return Byte.toUnsignedInt(this.source.get());
    }
}

