/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.wire.binary;

import io.usethesource.vallang.io.binary.util.ByteBufferOutputStream;
import io.usethesource.vallang.io.binary.util.TaggedInt;
import io.usethesource.vallang.io.binary.util.TrackLastWritten;
import io.usethesource.vallang.io.binary.util.WindowCacheFactory;
import io.usethesource.vallang.io.binary.wire.IWireOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class BinaryWireOutputStream
implements IWireOutputStream {
    private static final byte[] WIRE_VERSION = new byte[]{1, 0, 0};
    private boolean closed = false;
    private final OutputStream __stream;
    private final TrackLastWritten<String> stringsWritten;

    public BinaryWireOutputStream(OutputStream stream, int stringSharingWindowSize) throws IOException {
        this(stream, stringSharingWindowSize, 8192);
    }

    public BinaryWireOutputStream(OutputStream stream, int stringSharingWindowSize, int bufferSize) throws IOException {
        this.__stream = stream instanceof BufferedOutputStream || stream instanceof ByteBufferOutputStream ? stream : new BufferedOutputStream(stream, bufferSize);
        this.__stream.write(WIRE_VERSION);
        BinaryWireOutputStream.encodeInteger(this.__stream, stringSharingWindowSize);
        this.stringsWritten = WindowCacheFactory.getInstance().getTrackLastWrittenObjectEquality(stringSharingWindowSize);
    }

    @Override
    public void flush() throws IOException {
        this.__stream.flush();
    }

    private void writeBytes(byte[] bytes) throws IOException {
        this.__stream.write(bytes);
    }

    private static void encodeInteger(OutputStream stream, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            stream.write((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        stream.write((byte)value);
    }

    private void encodeInteger(int value) throws IOException {
        BinaryWireOutputStream.encodeInteger(this.__stream, value);
    }

    private void encodeString(String str) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        this.encodeInteger(bytes.length);
        this.writeBytes(bytes);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.__stream.close();
            }
            finally {
                this.closed = true;
                WindowCacheFactory.getInstance().returnTrackLastWrittenObjectEquality(this.stringsWritten);
            }
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
    }

    private void writeFieldTag(int fieldId, int type) throws IOException {
        this.encodeInteger(TaggedInt.make(fieldId, type));
    }

    @Override
    public void startMessage(int messageId) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(messageId, 0);
    }

    @Override
    public void writeField(int fieldId, String value) throws IOException {
        this.assertNotClosed();
        int alreadyWritten = this.stringsWritten.howLongAgo(value);
        if (alreadyWritten != -1) {
            this.writeFieldTag(fieldId, 1);
            this.encodeInteger(TaggedInt.make(alreadyWritten, 3));
        } else {
            this.writeFieldTag(fieldId, 3);
            this.encodeString(value);
            this.stringsWritten.write(value);
        }
    }

    @Override
    public void writeField(int fieldId, int value) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(fieldId, 2);
        this.encodeInteger(value);
    }

    @Override
    public void writeField(int fieldId, byte[] value) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(fieldId, 5);
        int size = value.length;
        if (size < 0x1FFFFFFF) {
            this.encodeInteger(TaggedInt.make(size, 0));
        } else {
            this.encodeInteger(TaggedInt.make(0x1FFFFFFF, 0));
            this.encodeInteger(size);
        }
        this.writeBytes(value);
    }

    @Override
    public void writeField(int fieldId, int[] values) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(fieldId, 5);
        int size = values.length;
        if (size < 0x1FFFFFFF) {
            this.encodeInteger(TaggedInt.make(size, 2));
        } else {
            this.encodeInteger(TaggedInt.make(0x1FFFFFFF, 2));
            this.encodeInteger(size);
        }
        for (int v : values) {
            this.encodeInteger(v);
        }
    }

    @Override
    public void writeField(int fieldId, String[] values) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(fieldId, 5);
        int size = values.length;
        if (size < 0x1FFFFFFF) {
            this.encodeInteger(TaggedInt.make(size, 3));
        } else {
            this.encodeInteger(TaggedInt.make(0x1FFFFFFF, 3));
            this.encodeInteger(size);
        }
        for (String s2 : values) {
            this.writeNestedString(s2);
        }
    }

    private void writeNestedString(String s2) throws IOException {
        int alreadyWritten = this.stringsWritten.howLongAgo(s2);
        if (alreadyWritten != -1) {
            this.encodeInteger(TaggedInt.make(alreadyWritten, 1));
        } else {
            this.encodeInteger(TaggedInt.make(0, 3));
            this.encodeString(s2);
            this.stringsWritten.write(s2);
        }
    }

    @Override
    public void writeNestedField(int fieldId) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(fieldId, 4);
    }

    @Override
    public void writeRepeatedNestedField(int fieldId, int numberOfNestedElements) throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(fieldId, 5);
        if (numberOfNestedElements <= 0x1FFFFFFF) {
            this.encodeInteger(TaggedInt.make(numberOfNestedElements, 4));
        } else {
            this.encodeInteger(TaggedInt.make(0x1FFFFFFF, 4));
            this.encodeInteger(numberOfNestedElements);
        }
    }

    @Override
    public void endMessage() throws IOException {
        this.assertNotClosed();
        this.writeFieldTag(0, 0);
    }
}

