/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.type.VoidType;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

class ListType
extends DefaultSubtypeOfValue {
    protected final Type fEltType;

    ListType(Type eltType) {
        this.fEltType = eltType;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public Type getElementType() {
        return this.fEltType;
    }

    @Override
    public boolean hasFieldNames() {
        return this.fEltType.hasFieldNames();
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isListRelation() {
        return this.fEltType.isTuple() || this.fEltType.isBottom();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fEltType.hasField(fieldName);
    }

    @Override
    public int getFieldIndex(String fieldName) {
        return this.fEltType.getFieldIndex(fieldName);
    }

    @Override
    public Type getFieldType(int i) {
        return this.fEltType.getFieldType(i);
    }

    @Override
    public String getFieldName(int i) {
        return this.fEltType.getFieldName(i);
    }

    @Override
    public String[] getFieldNames() {
        return this.fEltType.getFieldNames();
    }

    @Override
    public int getArity() {
        return this.fEltType.getArity();
    }

    @Override
    public Type getFieldType(String fieldName) throws FactTypeUseException {
        return this.fEltType.getFieldType(fieldName);
    }

    @Override
    public Type getFieldTypes() {
        return this.fEltType.getFieldTypes();
    }

    @Override
    public Type carrier() {
        return this.fEltType.carrier();
    }

    @Override
    public Type closure() {
        return TF.listType(this.fEltType.closure());
    }

    @Override
    public Type compose(Type other) {
        return TF.listType(this.fEltType.compose(other.getElementType()));
    }

    @Override
    public Type select(int ... fields) {
        return TF.listType(this.fEltType.select(fields));
    }

    @Override
    public Type select(String ... names) {
        return TF.listType(this.fEltType.select(names));
    }

    @Override
    public String toString() {
        if (this.fEltType.isFixedWidth() && !this.fEltType.equivalent(VoidType.getInstance())) {
            StringBuilder sb = new StringBuilder();
            sb.append("lrel[");
            int idx = 0;
            for (Type elemType : this.fEltType) {
                if (idx++ > 0) {
                    sb.append(",");
                }
                sb.append(elemType.toString());
                if (!this.hasFieldNames()) continue;
                sb.append(" " + this.fEltType.getFieldName(idx - 1));
            }
            sb.append("]");
            return sb.toString();
        }
        return "list[" + String.valueOf(this.fEltType) + "]";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ListType) {
            ListType other = (ListType)o;
            return this.fEltType == other.fEltType;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 75703 + 104543 * this.fEltType.hashCode();
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitList(this);
    }

    @Override
    public boolean isOpen() {
        return this.fEltType.isOpen();
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithList(this);
    }

    @Override
    protected boolean intersectsWithList(Type type) {
        return true;
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfList(this);
    }

    @Override
    protected boolean isSubtypeOfList(Type type) {
        return this.fEltType.isSubtypeOf(type.getElementType());
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithList(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithList(this);
    }

    @Override
    public Type lubWithList(Type type) {
        return this == type ? this : TF.listType(this.fEltType.lub(type.getElementType()));
    }

    @Override
    protected Type glbWithList(Type type) {
        return this == type ? this : TF.listType(this.fEltType.glb(type.getElementType()));
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!super.match(matched, bindings)) {
            return false;
        }
        if (matched.isList() || matched.isAliased() && matched.getAliased().isList() || matched.isBottom()) {
            return this.getElementType().match(matched.getElementType(), bindings);
        }
        return true;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        return TypeFactory.getInstance().listType(this.getElementType().instantiate(bindings));
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        IListWriter result = vf.listWriter();
        if (maxDepth > 0 && random.nextBoolean()) {
            int size = Math.min(maxWidth, 1 + random.nextInt(maxDepth));
            if (!this.getElementType().isSubtypeOf(TypeFactory.getInstance().voidType())) {
                for (int i = 0; i < size; ++i) {
                    result.append(this.getElementType().randomValue(random, typesConfig, vf, store, typeParameters, maxDepth - 1, maxWidth));
                }
            }
        }
        IList done = (IList)result.done();
        this.match(done.getType(), typeParameters);
        return done;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            if (symbol.getConstructorType() == this.getListType()) {
                return this.tf().listType(this.symbols().fromSymbol((IConstructor)symbol.get("symbol"), store, grammar));
            }
            return this.tf().listType(this.symbols().fromSymbols((IList)symbol.get("symbols"), store, grammar));
        }

        @Override
        public Type getSymbolConstructorType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Type> getSymbolConstructorTypes() {
            return Arrays.stream(new Type[]{this.getListType(), this.getRelType()}).collect(Collectors.toSet());
        }

        private Type getRelType() {
            return this.symbols().typeSymbolConstructor("lrel", this.tf().listType(this.symbols().symbolADT()), "symbols");
        }

        private Type getListType() {
            return this.symbols().typeSymbolConstructor("list", this.symbols().symbolADT(), "symbol");
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            return vf.constructor(this.getListType(), type.getElementType().asSymbol(vf, store, grammar, done));
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            type.getElementType().asProductions(vf, store, grammar, done);
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().listType(next.apply(store, rnd));
        }

        @Override
        public boolean isRecursive() {
            return false;
        }
    }
}

