/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.random.util.RandomUtil;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

class NodeType
extends DefaultSubtypeOfValue {
    NodeType() {
    }

    public static NodeType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public String toString() {
        return "node";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o == NodeType.getInstance();
    }

    @Override
    public int hashCode() {
        return 20102;
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfNode(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithNode(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithNode(this);
    }

    @Override
    protected boolean intersectsWithNode(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithAbstractData(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithConstructor(Type type) {
        return true;
    }

    @Override
    protected boolean isSubtypeOfNode(Type type) {
        return true;
    }

    @Override
    protected Type lubWithAbstractData(Type type) {
        return this;
    }

    @Override
    protected Type lubWithConstructor(Type type) {
        return this;
    }

    @Override
    protected Type lubWithNode(Type type) {
        return type;
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithNode(this);
    }

    @Override
    protected Type glbWithNode(Type type) {
        return this;
    }

    @Override
    protected Type glbWithConstructor(Type type) {
        return type;
    }

    @Override
    protected Type glbWithAbstractData(Type type) {
        return type;
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitNode(this);
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        String name = random.nextBoolean() ? RandomUtil.string(random, 1 + random.nextInt(5)) : RandomUtil.stringAlpha(random, random.nextInt(5));
        int arity = maxDepth <= 0 ? 0 : random.nextInt(maxDepth);
        IValue[] args = new IValue[arity];
        for (int i = 0; i < arity; ++i) {
            args[i] = TypeFactory.getInstance().valueType().randomValue(random, typesConfig, vf, store, typeParameters, maxDepth - 1, maxWidth);
        }
        if (RandomUtil.oneEvery(random, 4) && maxDepth > 0) {
            int kwArity = 1 + random.nextInt(maxDepth);
            HashMap<String, IValue> kwParams = new HashMap<String, IValue>(kwArity);
            for (int i = 0; i < kwArity; ++i) {
                Object kwName = "";
                while (((String)kwName).isEmpty()) {
                    kwName = RandomUtil.stringAlpha(random, 3);
                }
                kwName = (String)kwName + RandomUtil.stringAlphaNumeric(random, 4);
                kwParams.put((String)kwName, TypeFactory.getInstance().valueType().randomValue(random, typesConfig, vf, store, typeParameters, maxDepth - 1, maxWidth));
            }
            return vf.node(name, args, kwParams);
        }
        return vf.node(name, args);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("node", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return NodeType.getInstance();
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().nodeType();
        }
    }

    protected static class InstanceKeeper {
        public static final NodeType sInstance = new NodeType();

        protected InstanceKeeper() {
        }
    }
}

