/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.exceptions.UndeclaredFieldException;
import io.usethesource.vallang.type.TupleType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class TupleTypeWithFieldNames
extends TupleType {
    final String[] fFieldNames;

    TupleTypeWithFieldNames(Type[] fieldTypes, String[] fieldNames) {
        super(fieldTypes);
        assert (fieldTypes.length != 0) : "nullary tuples should be instances of TupleType without field names";
        this.fFieldNames = fieldNames;
    }

    @Override
    public boolean hasFieldNames() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Type getFieldType(int i) {
        return this.fFieldTypes[i];
    }

    @Override
    public Type getFieldType(String fieldName) {
        return this.getFieldType(this.getFieldIndex(fieldName));
    }

    @Override
    public int getFieldIndex(String fieldName) throws FactTypeUseException {
        for (int i = this.fFieldNames.length - 1; i >= 0; --i) {
            if (!this.fFieldNames[i].equals(fieldName)) continue;
            return i;
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        for (int i = this.fFieldNames.length - 1; i >= 0; --i) {
            if (!this.fFieldNames[i].equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getArity() {
        return this.fFieldTypes.length;
    }

    @Override
    public Type compose(Type other) {
        String fieldNameRight;
        String fieldNameLeft;
        if (other.equivalent(TF.voidType())) {
            return other;
        }
        if (this.getArity() != 2 || other.getArity() != 2) {
            throw new IllegalOperationException("compose", this, other);
        }
        if (!this.getFieldType(1).comparable(other.getFieldType(0))) {
            return TF.voidType();
        }
        if (other.hasFieldNames() && !(fieldNameLeft = this.getFieldName(0)).equals(fieldNameRight = other.getFieldName(1))) {
            return TF.tupleType(this.getFieldType(0), fieldNameLeft, other.getFieldType(1), fieldNameRight);
        }
        return TF.tupleType(this.getFieldType(0), other.getFieldType(1));
    }

    private static Type lubNamedTupleTypes(Type t1, Type t2) {
        int N2 = t1.getArity();
        Object[] fieldTypes = new Object[N2 * 2];
        Type[] types = new Type[N2];
        boolean first = t1.hasFieldNames();
        boolean second = t2.hasFieldNames();
        boolean consistent = true;
        int i = 0;
        int j = 0;
        while (i < N2) {
            Type lub;
            types[i] = lub = t1.getFieldType(i).lub(t2.getFieldType(i));
            fieldTypes[j++] = lub;
            if (first && second) {
                String fieldName2;
                String fieldName1 = t1.getFieldName(i);
                if (fieldName1.equals(fieldName2 = t2.getFieldName(i))) {
                    fieldTypes[j] = fieldName1;
                } else {
                    consistent = false;
                }
            } else if (first) {
                fieldTypes[j] = t1.getFieldName(i);
            } else if (second) {
                fieldTypes[i] = t2.getFieldName(i);
            }
            ++i;
            ++j;
        }
        if (consistent && (first || second)) {
            return TypeFactory.getInstance().tupleType(fieldTypes);
        }
        return TypeFactory.getInstance().tupleType(types);
    }

    private static Type glbNamedTupleTypes(Type t1, Type t2) {
        int N2 = t1.getArity();
        Object[] fieldTypes = new Object[N2 * 2];
        Type[] types = new Type[N2];
        boolean first = t1.hasFieldNames();
        boolean second = t2.hasFieldNames();
        boolean consistent = true;
        int i = 0;
        int j = 0;
        while (i < N2) {
            Type lub;
            types[i] = lub = t1.getFieldType(i).glb(t2.getFieldType(i));
            fieldTypes[j++] = lub;
            if (first && second) {
                String fieldName2;
                String fieldName1 = t1.getFieldName(i);
                if (fieldName1.equals(fieldName2 = t2.getFieldName(i))) {
                    fieldTypes[j] = fieldName1;
                } else {
                    consistent = false;
                }
            } else if (first) {
                fieldTypes[j] = t1.getFieldName(i);
            } else if (second) {
                fieldTypes[i] = t2.getFieldName(i);
            }
            ++i;
            ++j;
        }
        if (consistent && first && second) {
            return TypeFactory.getInstance().tupleType(fieldTypes);
        }
        return TypeFactory.getInstance().tupleType(types);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TupleTypeWithFieldNames other = (TupleTypeWithFieldNames)obj;
        if (this.fFieldTypes.length != other.fFieldTypes.length) {
            return false;
        }
        for (int i = this.fFieldTypes.length - 1; i >= 0; --i) {
            if (this.fFieldTypes[i] != other.fFieldTypes[i]) {
                return false;
            }
            if (this.fFieldNames[i].equals(other.fFieldNames[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tuple[");
        int idx = 0;
        for (Type elemType : this.fFieldTypes) {
            if (idx++ > 0) {
                sb.append(",");
            }
            sb.append(elemType.toString());
            sb.append(" " + Objects.requireNonNull(this.fFieldNames)[idx - 1]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected Type lubWithTuple(Type type) {
        if (this.getArity() == type.getArity()) {
            if (type.hasFieldNames() || this.hasFieldNames()) {
                return TupleTypeWithFieldNames.lubNamedTupleTypes(this, type);
            }
            return super.lubWithTuple(type);
        }
        return TF.valueType();
    }

    @Override
    protected Type glbWithTuple(Type type) {
        if (this.getArity() == type.getArity()) {
            if (type.hasFieldNames()) {
                return TupleTypeWithFieldNames.glbNamedTupleTypes(this, type);
            }
            return super.glbWithTuple(type);
        }
        return TF.voidType();
    }

    @Override
    @Pure
    public String getFieldName(int i) {
        return this.fFieldNames[i];
    }

    @Override
    @Pure
    public String[] getFieldNames() {
        return this.fFieldNames;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        Type[] fTypes = new Type[this.getArity()];
        String[] fLabels = new String[this.getArity()];
        for (int i = fTypes.length - 1; i >= 0; --i) {
            fTypes[i] = this.getFieldType(i).instantiate(bindings);
            fLabels[i] = this.getFieldName(i);
        }
        return TypeFactory.getInstance().tupleType(fTypes, fLabels);
    }

    @Override
    public Type select(int ... fields) {
        int width = fields.length;
        if (width == 0) {
            return TypeFactory.getInstance().voidType();
        }
        if (width == 1) {
            return this.getFieldType(fields[0]);
        }
        Type[] fieldTypes = new Type[width];
        String[] fieldNames = new String[width];
        boolean seenDuplicate = false;
        for (int i = width - 1; i >= 0; --i) {
            fieldTypes[i] = this.getFieldType(fields[i]);
            fieldNames[i] = Objects.requireNonNull(this.getFieldName(fields[i]));
            for (int j = width - 1; j > i; --j) {
                if (!fieldNames[j].equals(fieldNames[i])) continue;
                seenDuplicate = true;
            }
        }
        if (!seenDuplicate) {
            return TypeFactory.getInstance().tupleType(fieldTypes, fieldNames);
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    @Override
    public Type select(String ... names) {
        int[] indexes = new int[names.length];
        int i = 0;
        for (String name : names) {
            indexes[i] = this.getFieldIndex(name);
        }
        return this.select(indexes);
    }
}

