/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.TupleType;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public abstract class Type
implements Iterable<Type>,
Comparable<Type> {
    protected static final TypeFactory TF = TypeFactory.getInstance();

    protected abstract TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues var1);

    public Type getElementType() {
        throw new IllegalOperationException("getElementType", this);
    }

    public Type getKeyType() {
        throw new IllegalOperationException("getKeyType", this);
    }

    public Type getValueType() {
        throw new IllegalOperationException("getValueType", this);
    }

    public String getName() {
        throw new IllegalOperationException("getName", this);
    }

    public Type getFieldType(int i) {
        throw new IllegalOperationException("getFieldType", this);
    }

    public Type getFieldType(String fieldName) throws FactTypeUseException {
        throw new IllegalOperationException("getFieldType", this);
    }

    public Type getFieldTypes() {
        throw new IllegalOperationException("getFieldTypes", this);
    }

    public Type getReturnType() {
        throw new IllegalOperationException("getReturnType", this);
    }

    public Type getKeywordParameterTypes() {
        throw new IllegalOperationException("getKeywordParameterTypes", this);
    }

    public String getFieldName(int i) {
        throw new IllegalOperationException("getFieldName", this);
    }

    public Optional<String> getOptionalFieldName(int i) {
        if (this.hasFieldNames()) {
            return Optional.of(Objects.requireNonNull(this.getFieldName(i)));
        }
        return Optional.empty();
    }

    @Pure
    public String[] getFieldNames() {
        throw new IllegalOperationException("getFieldNames", this);
    }

    public int getFieldIndex(String fieldName) {
        throw new IllegalOperationException("getFieldIndex", this);
    }

    public boolean hasField(String fieldName) {
        throw new IllegalOperationException("hasField", this);
    }

    public boolean hasField(String fieldName, TypeStore store) {
        return this.hasField(fieldName);
    }

    public boolean hasKeywordField(String fieldName, TypeStore store) {
        throw new IllegalOperationException("hasKeywordField", this);
    }

    public int getArity() {
        throw new IllegalOperationException("getArity", this);
    }

    public IConstructor asSymbol(IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
        return this.getTypeReifier(TF.cachedTypeValues()).toSymbol(this, vf, store, grammar, done);
    }

    public void asProductions(IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
        this.getTypeReifier(TF.cachedTypeValues()).asProductions(this, vf, store, grammar, done);
    }

    public Type compose(Type other) {
        throw new IllegalOperationException("compose", this, other);
    }

    public Type closure() {
        throw new IllegalOperationException("closure", this);
    }

    public Type carrier() {
        throw new IllegalOperationException("carrier", this);
    }

    @Override
    public Iterator<Type> iterator() {
        throw new IllegalOperationException("iterator", this);
    }

    public Type select(int ... fields) {
        throw new IllegalOperationException("select", this);
    }

    public Type select(String ... names) {
        throw new IllegalOperationException("select", this);
    }

    public Type getAbstractDataType() {
        throw new IllegalOperationException("getAbstractDataType", this);
    }

    public Type getAliased() {
        throw new IllegalOperationException("getAliased", this);
    }

    public Type getBound() {
        throw new IllegalOperationException("getBound", this);
    }

    @Pure
    public boolean hasFieldNames() {
        return false;
    }

    @Pure
    public boolean hasKeywordParameters() {
        return false;
    }

    public @Nullable Type getKeywordParameterType(String label) {
        throw new IllegalOperationException("getKeywordParameterType", this);
    }

    @EnsuresNonNullIf(expression={"getKeywordParameterType(#1)"}, result=true)
    public boolean hasKeywordParameter(String label) {
        throw new IllegalOperationException("hasKeywordParameter", this);
    }

    public String getKeyLabel() {
        throw new IllegalOperationException("getKeyLabel", this);
    }

    public String getValueLabel() {
        throw new IllegalOperationException("getValueLabel", this);
    }

    public abstract Type lub(Type var1);

    public abstract Type glb(Type var1);

    public final boolean isSubtypeOf(Type other) {
        return other == this || other.isSupertypeOf(this);
    }

    public final boolean isStrictSubtypeOf(Type other) {
        return !other.equivalent(this) && other.isSupertypeOf(this);
    }

    protected abstract boolean isSupertypeOf(Type var1);

    public boolean isParameterized() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isAliased() {
        return false;
    }

    public boolean isSet() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isBool() {
        return false;
    }

    public boolean isRelation() {
        return false;
    }

    public boolean isListRelation() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public boolean isAbstractData() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isSourceLocation() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isExternalType() {
        return false;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public final boolean comparable(Type other) {
        return other == this || this.isSubtypeOf(other) || other.isSubtypeOf(this);
    }

    public abstract boolean intersects(Type var1);

    public final boolean equivalent(Type other) {
        return other == this || this.isSubtypeOf(other) && other.isSubtypeOf(this);
    }

    public Type instantiate(Map<Type, Type> bindings) {
        return this;
    }

    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        return matched.isSubtypeOf(this);
    }

    public abstract <T, E extends Throwable> T accept(ITypeVisitor<T, E> var1) throws E;

    public Type getTypeParameters() {
        throw new IllegalOperationException("getTypeParameters", this);
    }

    @Override
    public int compareTo(Type o) {
        if (this.isSubtypeOf(o)) {
            return o.isSubtypeOf(this) ? this.toString().compareTo(o.toString()) : -1;
        }
        if (o.isSubtypeOf(this)) {
            assert (!this.isSubtypeOf(o));
            return 1;
        }
        assert (!this.isSubtypeOf(o) && !o.isSubtypeOf(this));
        return this.toString().compareTo(o.toString());
    }

    protected boolean isSubtypeOfParameter(Type type) {
        return this.isSubtypeOf(type.getBound());
    }

    protected final boolean isSubtypeOfAlias(Type type) {
        return this.isSubtypeOf(type.getAliased());
    }

    protected Type instantiateTuple(TupleType t2, Map<Type, Type> bindings) {
        Type[] fChildren = new Type[t2.getArity()];
        for (int i = t2.fFieldTypes.length - 1; i >= 0; --i) {
            fChildren[i] = t2.getFieldType(i).instantiate(bindings);
        }
        return TypeFactory.getInstance().getFromCache(new TupleType(fChildren));
    }

    protected abstract boolean isSubtypeOfReal(Type var1);

    protected abstract boolean isSubtypeOfInteger(Type var1);

    protected abstract boolean isSubtypeOfRational(Type var1);

    protected abstract boolean isSubtypeOfList(Type var1);

    protected abstract boolean isSubtypeOfMap(Type var1);

    protected abstract boolean isSubtypeOfNumber(Type var1);

    protected abstract boolean isSubtypeOfSet(Type var1);

    protected abstract boolean isSubtypeOfSourceLocation(Type var1);

    protected abstract boolean isSubtypeOfString(Type var1);

    protected abstract boolean isSubtypeOfNode(Type var1);

    protected abstract boolean isSubtypeOfConstructor(Type var1);

    protected abstract boolean isSubtypeOfAbstractData(Type var1);

    protected abstract boolean isSubtypeOfTuple(Type var1);

    protected abstract boolean isSubtypeOfFunction(Type var1);

    protected abstract boolean isSubtypeOfValue(Type var1);

    protected abstract boolean isSubtypeOfVoid(Type var1);

    protected abstract boolean isSubtypeOfBool(Type var1);

    protected abstract boolean isSubtypeOfExternal(Type var1);

    protected abstract boolean isSubtypeOfDateTime(Type var1);

    protected abstract boolean intersectsWithReal(Type var1);

    protected abstract boolean intersectsWithInteger(Type var1);

    protected abstract boolean intersectsWithRational(Type var1);

    protected abstract boolean intersectsWithList(Type var1);

    protected abstract boolean intersectsWithMap(Type var1);

    protected abstract boolean intersectsWithNumber(Type var1);

    protected abstract boolean intersectsWithSet(Type var1);

    protected abstract boolean intersectsWithSourceLocation(Type var1);

    protected abstract boolean intersectsWithString(Type var1);

    protected abstract boolean intersectsWithNode(Type var1);

    protected abstract boolean intersectsWithConstructor(Type var1);

    protected abstract boolean intersectsWithAbstractData(Type var1);

    protected abstract boolean intersectsWithTuple(Type var1);

    protected abstract boolean intersectsWithFunction(Type var1);

    protected abstract boolean intersectsWithValue(Type var1);

    protected abstract boolean intersectsWithVoid(Type var1);

    protected abstract boolean intersectsWithBool(Type var1);

    protected boolean intersectsWithExternal(Type type) {
        return type.intersects(this);
    }

    protected abstract boolean intersectsWithDateTime(Type var1);

    protected Type lubWithAlias(Type type) {
        return this.lub(type.getAliased());
    }

    protected Type lubWithParameter(Type type) {
        if (type == this) {
            return this;
        }
        return this.lub(type.getBound());
    }

    protected abstract Type lubWithReal(Type var1);

    protected abstract Type lubWithInteger(Type var1);

    protected abstract Type lubWithRational(Type var1);

    protected abstract Type lubWithList(Type var1);

    protected abstract Type lubWithMap(Type var1);

    protected abstract Type lubWithNumber(Type var1);

    protected abstract Type lubWithSet(Type var1);

    protected abstract Type lubWithSourceLocation(Type var1);

    protected abstract Type lubWithString(Type var1);

    protected abstract Type lubWithNode(Type var1);

    protected abstract Type lubWithConstructor(Type var1);

    protected abstract Type lubWithAbstractData(Type var1);

    protected abstract Type lubWithTuple(Type var1);

    protected abstract Type lubWithFunction(Type var1);

    protected abstract Type lubWithValue(Type var1);

    protected abstract Type lubWithVoid(Type var1);

    protected abstract Type lubWithBool(Type var1);

    protected abstract Type lubWithDateTime(Type var1);

    protected Type glbWithAlias(Type type) {
        return this.glb(type.getAliased());
    }

    protected Type glbWithParameter(Type type) {
        if (type == this) {
            return this;
        }
        return this.glb(type.getBound());
    }

    protected abstract Type glbWithReal(Type var1);

    protected abstract Type glbWithInteger(Type var1);

    protected abstract Type glbWithRational(Type var1);

    protected abstract Type glbWithList(Type var1);

    protected abstract Type glbWithMap(Type var1);

    protected abstract Type glbWithNumber(Type var1);

    protected abstract Type glbWithSet(Type var1);

    protected abstract Type glbWithSourceLocation(Type var1);

    protected abstract Type glbWithString(Type var1);

    protected abstract Type glbWithNode(Type var1);

    protected abstract Type glbWithConstructor(Type var1);

    protected abstract Type glbWithAbstractData(Type var1);

    protected abstract Type glbWithTuple(Type var1);

    protected abstract Type glbWithFunction(Type var1);

    protected abstract Type glbWithValue(Type var1);

    protected abstract Type glbWithVoid(Type var1);

    protected abstract Type glbWithBool(Type var1);

    protected abstract Type glbWithDateTime(Type var1);

    protected Type lubWithExternal(Type type) {
        return this.lub(type);
    }

    protected Type glbWithExternal(Type type) {
        return this.glb(type);
    }

    public abstract IValue randomValue(Random var1, TypeFactory.RandomTypesConfig var2, IValueFactory var3, TypeStore var4, Map<Type, Type> var5, int var6, int var7);
}

