/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.MessageIssue;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;

public class RemoteEndpoint
implements Endpoint,
MessageConsumer,
MessageIssueHandler,
MethodProvider {
    private static final Logger LOG = Logger.getLogger(RemoteEndpoint.class.getName());
    public static final Function<Throwable, ResponseError> DEFAULT_EXCEPTION_HANDLER = throwable -> {
        if (throwable instanceof ResponseErrorException) {
            return ((ResponseErrorException)throwable).getResponseError();
        }
        if ((throwable instanceof CompletionException || throwable instanceof InvocationTargetException) && throwable.getCause() instanceof ResponseErrorException) {
            return ((ResponseErrorException)throwable.getCause()).getResponseError();
        }
        return RemoteEndpoint.fallbackResponseError("Internal error", throwable);
    };
    private final MessageConsumer out;
    private final Endpoint localEndpoint;
    private final Function<Throwable, ResponseError> exceptionHandler;
    private MessageJsonHandler jsonHandler;
    private final AtomicInteger nextRequestId = new AtomicInteger();
    private final Map<String, PendingRequestInfo> sentRequestMap = new LinkedHashMap<String, PendingRequestInfo>();
    private final Map<String, CompletableFuture<?>> receivedRequestMap = new LinkedHashMap();

    private static ResponseError fallbackResponseError(String header, Throwable throwable) {
        LOG.log(Level.SEVERE, header + ": " + throwable.getMessage(), throwable);
        ResponseError error = new ResponseError();
        error.setMessage(header + ".");
        error.setCode(ResponseErrorCode.InternalError);
        ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
        PrintWriter stackTraceWriter = new PrintWriter(stackTrace);
        throwable.printStackTrace(stackTraceWriter);
        stackTraceWriter.flush();
        error.setData(stackTrace.toString());
        return error;
    }

    public RemoteEndpoint(MessageConsumer out, Endpoint localEndpoint, Function<Throwable, ResponseError> exceptionHandler) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (localEndpoint == null) {
            throw new NullPointerException("localEndpoint");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler");
        }
        this.out = out;
        this.localEndpoint = localEndpoint;
        this.exceptionHandler = exceptionHandler;
    }

    public RemoteEndpoint(MessageConsumer out, Endpoint localEndpoint) {
        this(out, localEndpoint, DEFAULT_EXCEPTION_HANDLER);
    }

    public void setJsonHandler(MessageJsonHandler jsonHandler) {
        this.jsonHandler = jsonHandler;
    }

    public MessageJsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    @Override
    public void notify(String method, Object parameter) {
        NotificationMessage notificationMessage = this.createNotificationMessage(method, parameter);
        try {
            this.out.consume(notificationMessage);
        }
        catch (Exception exception) {
            Level logLevel = JsonRpcException.indicatesStreamClosed(exception) ? Level.INFO : Level.WARNING;
            LOG.log(logLevel, "Failed to send notification message.", exception);
        }
    }

    protected NotificationMessage createNotificationMessage(String method, Object parameter) {
        NotificationMessage notificationMessage = new NotificationMessage();
        notificationMessage.setJsonHandler(this.getJsonHandler());
        notificationMessage.setJsonrpc("2.0");
        notificationMessage.setMethod(method);
        notificationMessage.setParams(parameter);
        return notificationMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> request(String method, Object parameter) {
        final RequestMessage requestMessage = this.createRequestMessage(method, parameter);
        CompletableFuture<Object> result = new CompletableFuture<Object>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                RemoteEndpoint.this.sendCancelNotification(requestMessage.getRawId());
                return super.cancel(mayInterruptIfRunning);
            }
        };
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            this.sentRequestMap.put(requestMessage.getId(), new PendingRequestInfo(requestMessage, result));
        }
        try {
            this.out.consume(requestMessage);
        }
        catch (Exception exception) {
            result.completeExceptionally(exception);
        }
        return result;
    }

    protected RequestMessage createRequestMessage(String method, Object parameter) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setJsonHandler(this.getJsonHandler());
        requestMessage.setId(String.valueOf(this.nextRequestId.incrementAndGet()));
        requestMessage.setMethod(method);
        requestMessage.setParams(parameter);
        return requestMessage;
    }

    protected void sendCancelNotification(Either<String, Number> id) {
        CancelParams cancelParams = new CancelParams();
        cancelParams.setRawId(id);
        this.notify(MessageJsonHandler.CANCEL_METHOD.getMethodName(), cancelParams);
    }

    @Override
    public void consume(Message message) {
        if (message instanceof NotificationMessage) {
            NotificationMessage notificationMessage = (NotificationMessage)message;
            this.handleNotification(notificationMessage);
        } else if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            this.handleRequest(requestMessage);
        } else if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            this.handleResponse(responseMessage);
        } else {
            LOG.log(Level.WARNING, "Unkown message type.", message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponse(ResponseMessage responseMessage) {
        PendingRequestInfo requestInfo;
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            requestInfo = this.sentRequestMap.remove(responseMessage.getId());
        }
        if (requestInfo == null) {
            LOG.log(Level.WARNING, "Unmatched response message: " + responseMessage);
        } else if (responseMessage.getError() != null) {
            requestInfo.future.completeExceptionally(new ResponseErrorException(responseMessage.getError()));
        } else {
            requestInfo.future.complete(responseMessage.getResult());
        }
    }

    protected void handleNotification(NotificationMessage notificationMessage) {
        if (!this.handleCancellation(notificationMessage)) {
            try {
                this.localEndpoint.notify(notificationMessage.getMethod(), notificationMessage.getParams());
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Notification threw an exception: " + notificationMessage, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleCancellation(NotificationMessage notificationMessage) {
        if (MessageJsonHandler.CANCEL_METHOD.getMethodName().equals(notificationMessage.getMethod())) {
            Object cancelParams = notificationMessage.getParams();
            if (cancelParams != null) {
                if (cancelParams instanceof CancelParams) {
                    Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
                    synchronized (map) {
                        String id = ((CancelParams)cancelParams).getId();
                        CompletableFuture<?> future = this.receivedRequestMap.get(id);
                        if (future != null) {
                            future.cancel(true);
                        } else {
                            LOG.warning("Unmatched cancel notification for request id " + id);
                        }
                    }
                    return true;
                }
                LOG.warning("Cancellation support is disabled, since the '" + MessageJsonHandler.CANCEL_METHOD.getMethodName() + "' method has been registered explicitly.");
            } else {
                LOG.warning("Missing 'params' attribute of cancel notification.");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(RequestMessage requestMessage) {
        CompletableFuture<?> future;
        try {
            future = this.localEndpoint.request(requestMessage.getMethod(), requestMessage.getParams());
        }
        catch (Throwable throwable) {
            ResponseError errorObject = this.exceptionHandler.apply(throwable);
            if (errorObject == null) {
                errorObject = RemoteEndpoint.fallbackResponseError("Internal error. Exception handler provided no error object", throwable);
            }
            this.out.consume(this.createErrorResponseMessage(requestMessage, errorObject));
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return;
        }
        String messageId = requestMessage.getId();
        Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
        synchronized (map) {
            this.receivedRequestMap.put(messageId, future);
        }
        ((CompletableFuture)((CompletableFuture)future.thenAccept(result -> this.out.consume(this.createResultResponseMessage(requestMessage, result)))).exceptionally(t2 -> {
            ResponseMessage responseMessage;
            if (this.isCancellation((Throwable)t2)) {
                String message = "The request (id: " + messageId + ", method: '" + requestMessage.getMethod() + "') has been cancelled";
                ResponseError errorObject = new ResponseError(ResponseErrorCode.RequestCancelled, message, null);
                responseMessage = this.createErrorResponseMessage(requestMessage, errorObject);
            } else {
                ResponseError errorObject = this.exceptionHandler.apply((Throwable)t2);
                if (errorObject == null) {
                    errorObject = RemoteEndpoint.fallbackResponseError("Internal error. Exception handler provided no error object", t2);
                }
                responseMessage = this.createErrorResponseMessage(requestMessage, errorObject);
            }
            this.out.consume(responseMessage);
            return null;
        })).thenApply(obj -> {
            Map<String, CompletableFuture<?>> map = this.receivedRequestMap;
            synchronized (map) {
                this.receivedRequestMap.remove(messageId);
            }
            return null;
        });
    }

    @Override
    public void handle(Message message, List<MessageIssue> issues) {
        if (issues.isEmpty()) {
            throw new IllegalArgumentException("The list of issues must not be empty.");
        }
        if (message instanceof RequestMessage) {
            RequestMessage requestMessage = (RequestMessage)message;
            this.handleRequestIssues(requestMessage, issues);
        } else if (message instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)message;
            this.handleResponseIssues(responseMessage, issues);
        } else {
            this.logIssues(message, issues);
        }
    }

    protected void logIssues(Message message, List<MessageIssue> issues) {
        for (MessageIssue issue : issues) {
            String logMessage = "Issue found in " + message.getClass().getSimpleName() + ": " + issue.getText();
            LOG.log(Level.WARNING, logMessage, issue.getCause());
        }
    }

    protected void handleRequestIssues(RequestMessage requestMessage, List<MessageIssue> issues) {
        ResponseError errorObject = new ResponseError();
        if (issues.size() == 1) {
            MessageIssue issue = issues.get(0);
            errorObject.setMessage(issue.getText());
            errorObject.setCode(issue.getIssueCode());
            errorObject.setData(issue.getCause());
        } else {
            if (requestMessage.getMethod() != null) {
                errorObject.setMessage("Multiple issues were found in '" + requestMessage.getMethod() + "' request.");
            } else {
                errorObject.setMessage("Multiple issues were found in request.");
            }
            errorObject.setCode(ResponseErrorCode.InvalidRequest);
            errorObject.setData(issues);
        }
        this.out.consume(this.createErrorResponseMessage(requestMessage, errorObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResponseIssues(ResponseMessage responseMessage, List<MessageIssue> issues) {
        PendingRequestInfo requestInfo;
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            requestInfo = this.sentRequestMap.remove(responseMessage.getId());
        }
        if (requestInfo == null) {
            LOG.log(Level.WARNING, "Unmatched response message: " + responseMessage);
            this.logIssues(responseMessage, issues);
        } else {
            requestInfo.future.completeExceptionally(new MessageIssueException((Message)responseMessage, issues));
        }
    }

    protected ResponseMessage createResponseMessage(RequestMessage requestMessage) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setJsonHandler(this.getJsonHandler());
        responseMessage.setRawId(requestMessage.getRawId());
        responseMessage.setJsonrpc("2.0");
        return responseMessage;
    }

    protected ResponseMessage createResultResponseMessage(RequestMessage requestMessage, Object result) {
        ResponseMessage responseMessage = this.createResponseMessage(requestMessage);
        responseMessage.setResult(result);
        return responseMessage;
    }

    protected ResponseMessage createErrorResponseMessage(RequestMessage requestMessage, ResponseError errorObject) {
        ResponseMessage responseMessage = this.createResponseMessage(requestMessage);
        responseMessage.setError(errorObject);
        return responseMessage;
    }

    protected boolean isCancellation(Throwable t2) {
        if (t2 instanceof CompletionException) {
            return this.isCancellation(t2.getCause());
        }
        return t2 instanceof CancellationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveMethod(String requestId) {
        Map<String, PendingRequestInfo> map = this.sentRequestMap;
        synchronized (map) {
            PendingRequestInfo requestInfo = this.sentRequestMap.get(requestId);
            if (requestInfo != null) {
                return requestInfo.requestMessage.getMethod();
            }
        }
        return null;
    }

    private static class PendingRequestInfo {
        RequestMessage requestMessage;
        CompletableFuture<Object> future;

        PendingRequestInfo(RequestMessage requestMessage2, CompletableFuture<Object> future2) {
            this.requestMessage = requestMessage2;
            this.future = future2;
        }
    }
}

