/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.IVisitable;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.AssignableEvaluator;
import org.rascalmpl.interpreter.BasicTypeEvaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.asserts.NotYetImplemented;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnsupportedPattern;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.values.IRascalValueFactory;

public abstract class AbstractAST
implements IVisitable,
Cloneable {
    protected static final TypeFactory TF = TypeFactory.getInstance();
    protected static final RascalTypeFactory RTF = RascalTypeFactory.getInstance();
    protected static final IRascalValueFactory VF = IRascalValueFactory.getInstance();
    protected ISourceLocation src;

    AbstractAST(ISourceLocation src) {
        this.src = src;
    }

    public Type getConcreteSyntaxType() {
        return null;
    }

    public abstract Object clone();

    protected <T extends AbstractAST> T clone(T in) {
        if (in == null) {
            return null;
        }
        return (T)((AbstractAST)in.clone());
    }

    public <T extends AbstractAST> List<T> clone(List<T> in) {
        ArrayList<AbstractAST> tmp = new ArrayList<AbstractAST>(in.size());
        for (AbstractAST elem : in) {
            tmp.add((AbstractAST)elem.clone());
        }
        return tmp;
    }

    public static <T extends AbstractAST> T newInstance(Class<T> clazz, Object ... args) {
        try {
            Constructor<?> cons = clazz.getConstructors()[0];
            cons.setAccessible(true);
            return (T)((AbstractAST)cons.newInstance(args));
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new ImplementationError("Can not instantiate AST object for " + clazz.getName(), e);
        }
    }

    public AbstractAST findNode(int offset) {
        if (this.src.getOffset() <= offset && offset < this.src.getOffset() + this.src.getLength()) {
            return this;
        }
        return null;
    }

    public static <T extends IValue> Result<T> makeResult(Type declaredType, IValue value, IEvaluatorContext ctx) {
        return ResultFactory.makeResult(declaredType, value, ctx);
    }

    public static Result<IValue> nothing() {
        return ResultFactory.nothing();
    }

    public <T> T accept(IASTVisitor<T> v) {
        return null;
    }

    public ISourceLocation getLocation() {
        return this.src;
    }

    public boolean equals(Object obj) {
        throw new ImplementationError("Missing generated hashCode/equals methods");
    }

    @Deprecated
    public IConstructor getTree() {
        throw new NotYetImplemented(this);
    }

    public int hashCode() {
        throw new ImplementationError("Missing generated concrete hashCode/equals methods");
    }

    @Deprecated
    public String toString() {
        return "AST debug info: " + this.getClass().getName() + " at " + this.src;
    }

    public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
        throw new NotYetImplemented(this);
    }

    public Result<IValue> assignment(AssignableEvaluator eval) {
        throw new NotYetImplemented(this);
    }

    public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
        throw new NotYetImplemented(this);
    }

    public Type __evaluate(BasicTypeEvaluator eval) {
        throw new NotYetImplemented(this);
    }

    public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
        throw new UnsupportedPattern(this.toString(), this);
    }

    public IMatchingResult getMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
        return this.buildMatcher(eval, bindTypeParameters);
    }

    protected void addForLineNumber(int line, List<AbstractAST> result) {
    }

    public List<AbstractAST> breakpoints(int line) {
        LinkedList<AbstractAST> candidates = new LinkedList<AbstractAST>();
        this.addForLineNumber(line, candidates);
        return candidates.stream().filter(p -> p.isBreakable()).collect(Collectors.toList());
    }

    public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
        throw new NotYetImplemented(this);
    }

    public IBooleanResult getBacktracker(IEvaluatorContext ctx) {
        return this.buildBacktracker(ctx);
    }

    public boolean isBreakable() {
        return false;
    }

    public ISourceLocation getDebugStepScope() {
        return this.getLocation();
    }

    public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
        __eval.warning("INTERNAL WARNING: generic implementation of isDefined triggered", this.getLocation());
        try {
            this.interpret(__eval);
            return ResultFactory.makeResult(TF.boolType(), VF.bool(true), __eval);
        }
        catch (Throw e) {
            return ResultFactory.makeResult(TF.boolType(), VF.bool(false), __eval);
        }
    }
}

