/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.QualifiedName;

public abstract class DataTypeSelector
extends AbstractAST {
    public DataTypeSelector(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasProduction() {
        return false;
    }

    public Name getProduction() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasSort() {
        return false;
    }

    public QualifiedName getSort() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isSelector() {
        return false;
    }

    public static class Selector
    extends DataTypeSelector {
        private final QualifiedName sort;
        private final Name production;

        public Selector(ISourceLocation src, IConstructor node, QualifiedName sort, Name production) {
            super(src, node);
            this.sort = sort;
            this.production = production;
        }

        @Override
        public boolean isSelector() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitDataTypeSelectorSelector(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.sort.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.sort.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.production.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.production.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Selector)) {
                return false;
            }
            Selector tmp = (Selector)o;
            return tmp.sort.equals(this.sort) && tmp.production.equals(this.production);
        }

        @Override
        public int hashCode() {
            return 41 + 761 * this.sort.hashCode() + 971 * this.production.hashCode();
        }

        @Override
        public QualifiedName getSort() {
            return this.sort;
        }

        @Override
        public boolean hasSort() {
            return true;
        }

        @Override
        public Name getProduction() {
            return this.production;
        }

        @Override
        public boolean hasProduction() {
            return true;
        }

        @Override
        public Object clone() {
            return Selector.newInstance(this.getClass(), this.src, null, this.clone(this.sort), this.clone(this.production));
        }
    }
}

