/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;

public abstract class EvalCommand
extends AbstractAST {
    public EvalCommand(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasDeclaration() {
        return false;
    }

    public org.rascalmpl.ast.Declaration getDeclaration() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasImported() {
        return false;
    }

    public org.rascalmpl.ast.Import getImported() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasStatement() {
        return false;
    }

    public org.rascalmpl.ast.Statement getStatement() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDeclaration() {
        return false;
    }

    public boolean isImport() {
        return false;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isStatement() {
        return false;
    }

    public static class Statement
    extends EvalCommand {
        private final org.rascalmpl.ast.Statement statement;

        public Statement(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Statement statement) {
            super(src, node);
            this.statement = statement;
        }

        @Override
        public boolean isStatement() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitEvalCommandStatement(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.statement.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.statement.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Statement)) {
                return false;
            }
            Statement tmp = (Statement)o;
            return tmp.statement.equals(this.statement);
        }

        @Override
        public int hashCode() {
            return 157 + 83 * this.statement.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Statement getStatement() {
            return this.statement;
        }

        @Override
        public boolean hasStatement() {
            return true;
        }

        @Override
        public Object clone() {
            return Statement.newInstance(this.getClass(), this.src, null, this.clone(this.statement));
        }
    }

    public static class Output
    extends EvalCommand {
        public Output(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isOutput() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitEvalCommandOutput(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Output)) {
                return false;
            }
            Output tmp = (Output)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 647;
        }

        @Override
        public Object clone() {
            return Output.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Import
    extends EvalCommand {
        private final org.rascalmpl.ast.Import imported;

        public Import(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Import imported) {
            super(src, node);
            this.imported = imported;
        }

        @Override
        public boolean isImport() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitEvalCommandImport(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.imported.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.imported.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Import)) {
                return false;
            }
            Import tmp = (Import)o;
            return tmp.imported.equals(this.imported);
        }

        @Override
        public int hashCode() {
            return 197 + 233 * this.imported.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Import getImported() {
            return this.imported;
        }

        @Override
        public boolean hasImported() {
            return true;
        }

        @Override
        public Object clone() {
            return Import.newInstance(this.getClass(), this.src, null, this.clone(this.imported));
        }
    }

    public static class Declaration
    extends EvalCommand {
        private final org.rascalmpl.ast.Declaration declaration;

        public Declaration(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Declaration declaration) {
            super(src, node);
            this.declaration = declaration;
        }

        @Override
        public boolean isDeclaration() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitEvalCommandDeclaration(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.declaration.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.declaration.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Declaration)) {
                return false;
            }
            Declaration tmp = (Declaration)o;
            return tmp.declaration.equals(this.declaration);
        }

        @Override
        public int hashCode() {
            return 397 + 641 * this.declaration.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Declaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public boolean hasDeclaration() {
            return true;
        }

        @Override
        public Object clone() {
            return Declaration.newInstance(this.getClass(), this.src, null, this.clone(this.declaration));
        }
    }
}

