/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Formals
extends AbstractAST {
    public Formals(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasFormals() {
        return false;
    }

    public List<Expression> getFormals() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends Formals {
        private final List<Expression> formals;

        public Default(ISourceLocation src, IConstructor node, List<Expression> formals) {
            super(src, node);
            this.formals = formals;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFormalsDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.formals) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.formals.equals(this.formals);
        }

        @Override
        public int hashCode() {
            return 673 + 743 * this.formals.hashCode();
        }

        @Override
        public List<Expression> getFormals() {
            return this.formals;
        }

        @Override
        public boolean hasFormals() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.formals));
        }
    }
}

