/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;

public abstract class FunctionModifier
extends AbstractAST {
    public FunctionModifier(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isJava() {
        return false;
    }

    public boolean isTest() {
        return false;
    }

    public static class Test
    extends FunctionModifier {
        public Test(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isTest() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionModifierTest(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Test)) {
                return false;
            }
            Test tmp = (Test)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 2;
        }

        @Override
        public Object clone() {
            return Test.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Java
    extends FunctionModifier {
        public Java(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isJava() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionModifierJava(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Java)) {
                return false;
            }
            Java tmp = (Java)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 839;
        }

        @Override
        public Object clone() {
            return Java.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Default
    extends FunctionModifier {
        public Default(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionModifierDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 457;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null);
        }
    }
}

