/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.FunctionModifier;
import org.rascalmpl.ast.IASTVisitor;

public abstract class FunctionModifiers
extends AbstractAST {
    public FunctionModifiers(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasModifiers() {
        return false;
    }

    public List<FunctionModifier> getModifiers() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isModifierlist() {
        return false;
    }

    public static class Modifierlist
    extends FunctionModifiers {
        private final List<FunctionModifier> modifiers;

        public Modifierlist(ISourceLocation src, IConstructor node, List<FunctionModifier> modifiers) {
            super(src, node);
            this.modifiers = modifiers;
        }

        @Override
        public boolean isModifierlist() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionModifiersModifierlist(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.modifiers) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Modifierlist)) {
                return false;
            }
            Modifierlist tmp = (Modifierlist)o;
            return tmp.modifiers.equals(this.modifiers);
        }

        @Override
        public int hashCode() {
            return 461 + 877 * this.modifiers.hashCode();
        }

        @Override
        public List<FunctionModifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean hasModifiers() {
            return true;
        }

        @Override
        public Object clone() {
            return Modifierlist.newInstance(this.getClass(), this.src, null, this.clone(this.modifiers));
        }
    }
}

