/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Import;
import org.rascalmpl.ast.ModuleParameters;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.Tags;

public abstract class Header
extends AbstractAST {
    public Header(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasImports() {
        return false;
    }

    public List<Import> getImports() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasParams() {
        return false;
    }

    public ModuleParameters getParams() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasName() {
        return false;
    }

    public QualifiedName getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasTags() {
        return false;
    }

    public Tags getTags() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isParameters() {
        return false;
    }

    public static class Parameters
    extends Header {
        private final Tags tags;
        private final QualifiedName name;
        private final ModuleParameters params;
        private final List<Import> imports;

        public Parameters(ISourceLocation src, IConstructor node, Tags tags, QualifiedName name, ModuleParameters params, List<Import> imports) {
            super(src, node);
            this.tags = tags;
            this.name = name;
            this.params = params;
            this.imports = imports;
        }

        @Override
        public boolean isParameters() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitHeaderParameters(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.params.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.params.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.imports) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters tmp = (Parameters)o;
            return tmp.tags.equals(this.tags) && tmp.name.equals(this.name) && tmp.params.equals(this.params) && tmp.imports.equals(this.imports);
        }

        @Override
        public int hashCode() {
            return 173 + 761 * this.tags.hashCode() + 409 * this.name.hashCode() + 997 * this.params.hashCode() + 367 * this.imports.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public ModuleParameters getParams() {
            return this.params;
        }

        @Override
        public boolean hasParams() {
            return true;
        }

        @Override
        public List<Import> getImports() {
            return this.imports;
        }

        @Override
        public boolean hasImports() {
            return true;
        }

        @Override
        public Object clone() {
            return Parameters.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.name), this.clone(this.params), this.clone(this.imports));
        }
    }

    public static class Default
    extends Header {
        private final Tags tags;
        private final QualifiedName name;
        private final List<Import> imports;

        public Default(ISourceLocation src, IConstructor node, Tags tags, QualifiedName name, List<Import> imports) {
            super(src, node);
            this.tags = tags;
            this.name = name;
            this.imports = imports;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitHeaderDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.tags.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.tags.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.imports) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.tags.equals(this.tags) && tmp.name.equals(this.name) && tmp.imports.equals(this.imports);
        }

        @Override
        public int hashCode() {
            return 103 + 673 * this.tags.hashCode() + 509 * this.name.hashCode() + 61 * this.imports.hashCode();
        }

        @Override
        public Tags getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public List<Import> getImports() {
            return this.imports;
        }

        @Override
        public boolean hasImports() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.tags), this.clone(this.name), this.clone(this.imports));
        }
    }
}

