/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;

public abstract class QualifiedName
extends AbstractAST {
    public QualifiedName(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasNames() {
        return false;
    }

    public List<Name> getNames() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends QualifiedName {
        private final List<Name> names;

        public Default(ISourceLocation src, IConstructor node, List<Name> names) {
            super(src, node);
            this.names = names;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitQualifiedNameDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.names) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.names.equals(this.names);
        }

        @Override
        public int hashCode() {
            return 331 + 223 * this.names.hashCode();
        }

        @Override
        public List<Name> getNames() {
            return this.names;
        }

        @Override
        public boolean hasNames() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.names));
        }
    }
}

