/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.FunctionModifiers;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.Parameters;
import org.rascalmpl.ast.Type;

public abstract class Signature
extends AbstractAST {
    public Signature(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasExceptions() {
        return false;
    }

    public List<Type> getExceptions() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasModifiers() {
        return false;
    }

    public FunctionModifiers getModifiers() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasParameters() {
        return false;
    }

    public Parameters getParameters() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isNoThrows() {
        return false;
    }

    public boolean isWithThrows() {
        return false;
    }

    public static class WithThrows
    extends Signature {
        private final FunctionModifiers modifiers;
        private final Type type;
        private final Name name;
        private final Parameters parameters;
        private final List<Type> exceptions;

        public WithThrows(ISourceLocation src, IConstructor node, FunctionModifiers modifiers, Type type, Name name, Parameters parameters, List<Type> exceptions) {
            super(src, node);
            this.modifiers = modifiers;
            this.type = type;
            this.name = name;
            this.parameters = parameters;
            this.exceptions = exceptions;
        }

        @Override
        public boolean isWithThrows() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSignatureWithThrows(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.modifiers.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.modifiers.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.type.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.parameters.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.parameters.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.exceptions) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof WithThrows)) {
                return false;
            }
            WithThrows tmp = (WithThrows)o;
            return tmp.modifiers.equals(this.modifiers) && tmp.type.equals(this.type) && tmp.name.equals(this.name) && tmp.parameters.equals(this.parameters) && tmp.exceptions.equals(this.exceptions);
        }

        @Override
        public int hashCode() {
            return 131 + 827 * this.modifiers.hashCode() + 2 * this.type.hashCode() + 449 * this.name.hashCode() + 89 * this.parameters.hashCode() + 233 * this.exceptions.hashCode();
        }

        @Override
        public FunctionModifiers getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean hasModifiers() {
            return true;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Parameters getParameters() {
            return this.parameters;
        }

        @Override
        public boolean hasParameters() {
            return true;
        }

        @Override
        public List<Type> getExceptions() {
            return this.exceptions;
        }

        @Override
        public boolean hasExceptions() {
            return true;
        }

        @Override
        public Object clone() {
            return WithThrows.newInstance(this.getClass(), this.src, null, this.clone(this.modifiers), this.clone(this.type), this.clone(this.name), this.clone(this.parameters), this.clone(this.exceptions));
        }
    }

    public static class NoThrows
    extends Signature {
        private final FunctionModifiers modifiers;
        private final Type type;
        private final Name name;
        private final Parameters parameters;

        public NoThrows(ISourceLocation src, IConstructor node, FunctionModifiers modifiers, Type type, Name name, Parameters parameters) {
            super(src, node);
            this.modifiers = modifiers;
            this.type = type;
            this.name = name;
            this.parameters = parameters;
        }

        @Override
        public boolean isNoThrows() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSignatureNoThrows(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.modifiers.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.modifiers.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.type.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.parameters.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.parameters.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NoThrows)) {
                return false;
            }
            NoThrows tmp = (NoThrows)o;
            return tmp.modifiers.equals(this.modifiers) && tmp.type.equals(this.type) && tmp.name.equals(this.name) && tmp.parameters.equals(this.parameters);
        }

        @Override
        public int hashCode() {
            return 53 + 149 * this.modifiers.hashCode() + 127 * this.type.hashCode() + 827 * this.name.hashCode() + 431 * this.parameters.hashCode();
        }

        @Override
        public FunctionModifiers getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean hasModifiers() {
            return true;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Parameters getParameters() {
            return this.parameters;
        }

        @Override
        public boolean hasParameters() {
            return true;
        }

        @Override
        public Object clone() {
            return NoThrows.newInstance(this.getClass(), this.src, null, this.clone(this.modifiers), this.clone(this.type), this.clone(this.name), this.clone(this.parameters));
        }
    }
}

