/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Visibility
extends AbstractAST {
    public Visibility(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isPublic() {
        return false;
    }

    public static class Public
    extends Visibility {
        public Public(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVisibilityPublic(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Public)) {
                return false;
            }
            Public tmp = (Public)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 13;
        }

        @Override
        public Object clone() {
            return Public.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Private
    extends Visibility {
        public Private(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isPrivate() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVisibilityPrivate(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Private)) {
                return false;
            }
            Private tmp = (Private)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 701;
        }

        @Override
        public Object clone() {
            return Private.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Default
    extends Visibility {
        public Default(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVisibilityDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 641;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null);
        }
    }
}

