/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.exceptions;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.rascalmpl.exceptions.StackTraceEntry;

public class StackTrace
implements Iterable<StackTraceEntry> {
    public static final StackTrace EMPTY_STACK_TRACE = new StackTrace().freeze();
    protected List<StackTraceEntry> trace = new ArrayList<StackTraceEntry>();

    public StackTrace add(ISourceLocation loc, String funName) {
        this.trace.add(new StackTraceEntry(loc, funName));
        return this;
    }

    public StackTrace addAll(Iterable<StackTraceEntry> stackTrace) {
        if (stackTrace != null) {
            for (StackTraceEntry e : stackTrace) {
                this.trace.add(e);
            }
        }
        return this;
    }

    public void prettyPrintedString(Writer out, StandardTextWriter prettyPrinter) throws IOException {
        for (StackTraceEntry e : this.trace) {
            e.format(out, prettyPrinter);
        }
    }

    public String toString() {
        String string;
        StringWriter w = new StringWriter(4096);
        try {
            this.prettyPrintedString(w, new StandardTextWriter(false));
            string = w.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    w.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "Error printing stack trace";
            }
        }
        w.close();
        return string;
    }

    public StackTrace freeze() {
        UnmodifiableStackTrace result = new UnmodifiableStackTrace(this);
        this.trace = null;
        return result;
    }

    @Override
    public Iterator<StackTraceEntry> iterator() {
        return this.trace.iterator();
    }

    public int size() {
        return this.trace.size();
    }

    static class UnmodifiableStackTrace
    extends StackTrace {
        private UnmodifiableStackTrace(StackTrace original) {
            this.trace = Collections.unmodifiableList(original.trace);
        }

        @Override
        public StackTrace add(ISourceLocation loc, String funName) {
            throw new UnsupportedOperationException("This stack trace is unmodifiable");
        }

        @Override
        public StackTrace addAll(Iterable<StackTraceEntry> stackTrace) {
            throw new UnsupportedOperationException("This stack trace is unmodifiable");
        }

        @Override
        public StackTrace freeze() {
            return this;
        }
    }
}

