/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Optional;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Assignable;
import org.rascalmpl.ast.Assignment;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UninitializedVariable;

public class AssignableEvaluator {
    private AssignmentOperator operator;
    private Result<IValue> value;
    private final Environment env;
    private final IEvaluator<Result<IValue>> eval;
    private static final TypeFactory tf = TypeFactory.getInstance();

    public AssignableEvaluator(Environment env, Assignment operator, Result<IValue> value, IEvaluator<Result<IValue>> eval) {
        if (operator == null || operator.isDefault()) {
            this.__setOperator(AssignmentOperator.Default);
        } else if (operator.isAddition()) {
            this.__setOperator(AssignmentOperator.Addition);
        } else if (operator.isSubtraction()) {
            this.__setOperator(AssignmentOperator.Subtraction);
        } else if (operator.isProduct()) {
            this.__setOperator(AssignmentOperator.Product);
        } else if (operator.isDivision()) {
            this.__setOperator(AssignmentOperator.Division);
        } else if (operator.isIntersection()) {
            this.__setOperator(AssignmentOperator.Intersection);
        } else if (operator.isIfDefined()) {
            this.__setOperator(AssignmentOperator.IsDefined);
        } else {
            throw new ImplementationError("Unknown assignment operator");
        }
        this.__setValue(value);
        this.env = env;
        this.eval = eval;
    }

    public void __setValue(Result<IValue> value) {
        this.value = value;
    }

    public Result<IValue> __getValue() {
        return this.value;
    }

    public Environment __getEnv() {
        return this.env;
    }

    public void __setOperator(AssignmentOperator operator) {
        this.operator = operator;
    }

    public AssignmentOperator __getOperator() {
        return this.operator;
    }

    public IEvaluator<Result<IValue>> __getEval() {
        return this.eval;
    }

    public static TypeFactory __getTf() {
        return tf;
    }

    public Result<IValue> newResult(Result<IValue> oldValue, Result<IValue> rhsValue) {
        if (rhsValue.getStaticType().isBottom()) {
            throw new UnexpectedType(oldValue.getStaticType(), tf.voidType(), this.getCurrentAST());
        }
        if (oldValue != null) {
            Result<IValue> newValue;
            switch (this.__getOperator()) {
                case Default: {
                    newValue = rhsValue;
                    break;
                }
                case Addition: {
                    newValue = oldValue.add(rhsValue);
                    break;
                }
                case Subtraction: {
                    newValue = oldValue.subtract(rhsValue);
                    break;
                }
                case Product: {
                    newValue = oldValue.multiply(rhsValue);
                    break;
                }
                case Division: {
                    newValue = oldValue.divide(rhsValue);
                    break;
                }
                case Intersection: {
                    newValue = oldValue.intersect(rhsValue);
                    break;
                }
                case IsDefined: {
                    return oldValue;
                }
                default: {
                    throw new ImplementationError("Unknown assignment operator");
                }
            }
            if (newValue.getValue().getType().isSubtypeOf(oldValue.getStaticType())) {
                newValue = ResultFactory.makeResult(oldValue.getStaticType(), newValue.getValue(), this.__getEval());
                return newValue;
            }
            if (oldValue.hasInferredType()) {
                newValue = ResultFactory.makeResult(oldValue.getStaticType().lub(newValue.getStaticType()), newValue.getValue(), this.__getEval());
                newValue.setInferredType(true);
                return newValue;
            }
            throw new UnexpectedType(oldValue.getStaticType(), rhsValue.getStaticType(), this.__getEval().getCurrentAST());
        }
        switch (this.__getOperator()) {
            case Default: 
            case IsDefined: {
                return rhsValue;
            }
        }
        throw new UninitializedVariable("assignment operator", this.__getEval().getCurrentAST());
    }

    public Result<IValue> newResult(IValue oldValue, Result<IValue> rhsValue) {
        if (oldValue != null) {
            Result<IValue> res = ResultFactory.makeResult(oldValue.getType().lub(rhsValue.getStaticType()), oldValue, this.__getEval());
            return this.newResult(res, rhsValue);
        }
        switch (this.__getOperator()) {
            case Default: 
            case IsDefined: {
                return rhsValue;
            }
        }
        throw new UninitializedVariable("assignment operator", this.__getEval().getCurrentAST());
    }

    public Result<IValue> recur(Assignable x, Result<IValue> result) {
        return x.getReceiver().assignment(new AssignableEvaluator(this.__getEnv(), null, result, this.__getEval()));
    }

    public AbstractAST getCurrentAST() {
        return this.__getEval().getCurrentAST();
    }

    public Environment getCurrentEnvt() {
        return this.__getEval().getCurrentEnvt();
    }

    public IEvaluator<Result<IValue>> getEvaluator() {
        return this.__getEval().getEvaluator();
    }

    public GlobalEnvironment getHeap() {
        return this.__getEval().getHeap();
    }

    public StackTrace getStackTrace() {
        return this.__getEval().getStackTrace();
    }

    public void pushEnv() {
        this.__getEval().pushEnv();
    }

    public void runTests(IRascalMonitor monitor) {
        this.__getEval().runTests(monitor, Optional.empty());
    }

    public void setCurrentEnvt(Environment environment) {
        this.__getEval().setCurrentEnvt(environment);
    }

    public void unwind(Environment old) {
        this.__getEval().unwind(old);
    }

    public static enum AssignmentOperator {
        Default,
        Addition,
        Subtraction,
        Product,
        Division,
        Intersection,
        IsDefined;

    }
}

