/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.asserts;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public final class Ambiguous
extends AssertionError {
    private static final long serialVersionUID = -8740312542969306482L;
    private final ISourceLocation loc;
    private final ITree tree;

    public Ambiguous(ITree tree) {
        super((Object)("Ambiguous code (internal error), " + TreeAdapter.yield((IConstructor)tree, 100)));
        this.loc = this.computeLocation(tree);
        this.tree = tree;
    }

    private ISourceLocation computeLocation(ITree tree) {
        ISourceLocation tmp = (ISourceLocation)((IValue)TreeAdapter.getAlternatives(tree).iterator().next()).asWithKeywordParameters().getParameter("src");
        if (tmp == null) {
            return URIUtil.rootLocation("unknown");
        }
        return tmp;
    }

    public Ambiguous(ISourceLocation loc) {
        super((Object)"Ambiguous code (internal error)");
        this.loc = loc;
        this.tree = null;
    }

    public ISourceLocation getLocation() {
        return this.loc;
    }

    public ITree getTree() {
        return this.tree;
    }
}

