/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.AbstractBooleanResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;

public class BasicBooleanResult
extends AbstractBooleanResult {
    private Expression expr;
    private boolean firstTime = true;

    public BasicBooleanResult(IEvaluatorContext ctx, Expression expr) {
        super(ctx);
        this.expr = expr;
    }

    @Override
    public void init() {
        super.init();
        this.firstTime = true;
    }

    @Override
    public boolean hasNext() {
        return this.firstTime;
    }

    @Override
    public boolean next() {
        if (this.firstTime) {
            this.firstTime = false;
            Result<IValue> result = this.expr.interpret(this.ctx.getEvaluator());
            if (result.getStaticType().isBool() && result.getValue() != null) {
                return result.getValue().equals(this.ctx.getValueFactory().bool(true));
            }
            throw new UnexpectedType(this.tf.boolType(), result.getStaticType(), this.expr);
        }
        return false;
    }
}

