/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.matching.MultiVariablePattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;

public class TuplePattern
extends AbstractMatchingResult {
    private List<IMatchingResult> children;
    private ITuple treeSubject;
    private final TypeFactory tf = TypeFactory.getInstance();
    private int nextChild;
    private Type type;

    public TuplePattern(IEvaluatorContext ctx, Expression x, List<IMatchingResult> list) {
        super(ctx, x);
        this.children = list;
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        this.hasNext = false;
        if (!subject.getValue().getType().isTuple()) {
            return;
        }
        this.treeSubject = (ITuple)subject.getValue();
        if (this.treeSubject.arity() != this.children.size()) {
            return;
        }
        this.hasNext = true;
        for (int i = 0; i < this.children.size(); ++i) {
            IValue childValue = this.treeSubject.get(i);
            IMatchingResult child = this.children.get(i);
            if (child instanceof MultiVariablePattern) {
                throw new UnsupportedOperation("splice operator in a tuple match", this.getAST());
            }
            child.initMatch(ResultFactory.makeResult(childValue.getType(), childValue, this.ctx));
            this.hasNext = child.hasNext();
            if (!this.hasNext) break;
        }
        this.nextChild = 0;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        if (this.type == null) {
            Type[] fieldTypes = new Type[this.children.size()];
            for (int i = 0; i < this.children.size(); ++i) {
                fieldTypes[i] = this.children.get(i).getType(env, patternVars);
                patternVars = this.merge(patternVars, this.children.get(i).getVariables());
            }
            this.type = this.tf.tupleType(fieldTypes);
        }
        return this.type;
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        for (int i = 0; i < this.children.size(); ++i) {
            res.addAll(this.children.get(i).getVariables());
        }
        return res;
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        if (this.children.size() == 0) {
            this.hasNext = false;
            return true;
        }
        while (this.nextChild >= 0) {
            int i;
            IMatchingResult nextPattern = this.children.get(this.nextChild);
            if (nextPattern.hasNext() && nextPattern.next()) {
                if (this.nextChild == this.children.size() - 1) {
                    this.hasNext = false;
                    for (i = this.nextChild; i >= 0; --i) {
                        this.hasNext |= this.children.get(i).hasNext();
                    }
                    return true;
                }
                ++this.nextChild;
                continue;
            }
            --this.nextChild;
            if (this.nextChild < 0) continue;
            for (i = this.nextChild + 1; i < this.children.size(); ++i) {
                IValue childValue = this.treeSubject.get(i);
                IMatchingResult tailChild = this.children.get(i);
                tailChild.initMatch(ResultFactory.makeResult(childValue.getType(), childValue, this.ctx));
            }
        }
        this.hasNext = false;
        return false;
    }

    public List<IMatchingResult> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("<");
        String sep = "";
        for (IBooleanResult iBooleanResult : this.children) {
            res.append(sep);
            sep = ", ";
            res.append(iBooleanResult.toString());
        }
        res.append(">");
        return res.toString();
    }
}

