/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.TypeDeclarationEvaluator;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.result.ConcreteConstructorFunction;
import org.rascalmpl.interpreter.result.NamedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UnexpectedKeywordArgumentType;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.values.RascalValueFactory;

public class ConstructorFunction
extends NamedFunction {
    protected final Type constructorType;
    private Type kwTypes = null;
    private final List<KeywordFormal> initializers;

    public ConstructorFunction(AbstractAST ast, IEvaluator<Result<IValue>> eval, Environment env, Type constructorType, List<KeywordFormal> initializers) {
        super(ast, eval, TF.functionType(constructorType.getAbstractDataType(), constructorType.getFieldTypes(), TypeDeclarationEvaluator.computeKeywordParametersType(initializers, eval)), TF.functionType(constructorType.getAbstractDataType(), constructorType.getFieldTypes(), TypeDeclarationEvaluator.computeKeywordParametersType(initializers, eval)), initializers, constructorType.getName(), false, true, false, env);
        this.constructorType = constructorType;
        this.initializers = initializers;
    }

    public Type getConstructorType() {
        return this.constructorType;
    }

    @Override
    public ConstructorFunction cloneInto(Environment env) {
        return new ConstructorFunction(this.getAst(), this.getEval(), env, this.constructorType, this.initializers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<IValue> computeDefaultKeywordParameter(String label, IConstructor value, Environment callerEnvironment) {
        Set<ModuleEnvironment.GenericKeywordParameters> kws = callerEnvironment.lookupGenericKeywordParameters(this.constructorType.getAbstractDataType());
        IWithKeywordParameters<? extends IConstructor> wkw = value.asWithKeywordParameters();
        Environment old = this.ctx.getCurrentEnvt();
        Environment resultEnv = new Environment(this.declarationEnvironment, URIUtil.rootLocation("initializer"), "keyword parameter initializer");
        for (ModuleEnvironment.GenericKeywordParameters gkw : kws) {
            Environment env = new Environment(gkw.getEnv(), URIUtil.rootLocation("initializer"), "kwp initializer");
            try {
                this.ctx.setCurrentEnvt(env);
                for (KeywordFormal keywordFormal : gkw.getFormals()) {
                    Object def;
                    Result<IValue> kwResult;
                    String name = Names.name(keywordFormal.getName());
                    Type kwType = gkw.getTypes().get(name);
                    if (kwType == null) continue;
                    if (wkw.hasParameter(name)) {
                        Object r = wkw.getParameter(name);
                        if (!r.getType().isSubtypeOf(kwType)) {
                            throw new UnexpectedKeywordArgumentType(name, kwType, r.getType(), this.ctx.getCurrentAST());
                        }
                        kwResult = ResultFactory.makeResult(kwType, r, this.ctx);
                    } else {
                        def = keywordFormal.getExpression();
                        kwResult = ((AbstractAST)def).interpret(this.eval);
                    }
                    kwResult = ResultFactory.makeResult(kwType, kwResult.getValue(), this.ctx);
                    if (name.equals(label)) {
                        def = kwResult;
                        return def;
                    }
                    env.declareVariable(kwType, name);
                    env.storeVariable(name, kwResult);
                    resultEnv.declareVariable(kwType, name);
                    resultEnv.storeVariable(name, kwResult);
                }
            }
            finally {
                this.ctx.setCurrentEnvt(old);
            }
        }
        Type formals = this.getFunctionType().getFieldTypes();
        try {
            this.ctx.setCurrentEnvt(resultEnv);
            for (int i = 0; i < formals.getArity(); ++i) {
                String fieldName = formals.getFieldName(i);
                Type fieldType = formals.getFieldType(i);
                resultEnv.declareVariable(fieldType, fieldName);
                resultEnv.storeLocalVariable(fieldName, ResultFactory.makeResult(fieldType, value.get(fieldName), this.ctx));
            }
            for (String string : this.staticFunctionType.getKeywordParameterTypes().getFieldNames()) {
                Result<IValue> kwResult;
                Type kwType = this.staticFunctionType.getKeywordParameterType(string);
                if (wkw.hasParameter(string)) {
                    Object r = wkw.getParameter(string);
                    if (!r.getType().isSubtypeOf(kwType)) {
                        throw new UnexpectedKeywordArgumentType(string, kwType, r.getType(), this.ctx.getCurrentAST());
                    }
                    kwResult = ResultFactory.makeResult(kwType, r, this.ctx);
                } else {
                    Expression def = this.getKeywordParameterDefaults().get(string);
                    IValue res = def.interpret(this.eval).getValue();
                    if (!res.getType().isSubtypeOf(kwType)) {
                        throw new UnexpectedKeywordArgumentType(string, kwType, res.getType(), this.ctx.getCurrentAST());
                    }
                    kwResult = ResultFactory.makeResult(kwType, res, this.ctx);
                }
                if (string.equals(label)) {
                    Result<IValue> result = kwResult;
                    return result;
                }
                resultEnv.declareVariable(kwType, string);
                resultEnv.storeVariable(string, kwResult);
            }
            throw new UndeclaredField(label, this.constructorType, this.ctx.getCurrentAST());
        }
        finally {
            this.ctx.setCurrentEnvt(old);
        }
    }

    @Override
    public Type getKeywordArgumentTypes(Environment env) {
        if (this.kwTypes != null) {
            return this.kwTypes;
        }
        Type kwTypes = this.staticFunctionType.getKeywordParameterTypes();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String> labels = new ArrayList<String>();
        for (String label : kwTypes.getFieldNames()) {
            types.add(kwTypes.getFieldType(label));
            labels.add(label);
        }
        Set<ModuleEnvironment.GenericKeywordParameters> kws = env.lookupGenericKeywordParameters(this.constructorType.getAbstractDataType());
        for (ModuleEnvironment.GenericKeywordParameters p : kws) {
            Map<String, Type> m4 = p.getTypes();
            for (String name : m4.keySet()) {
                labels.add(name);
                types.add(m4.get(name));
            }
        }
        Type[] typeArray = types.toArray(new Type[0]);
        String[] stringArray = labels.toArray(new String[0]);
        kwTypes = TypeFactory.getInstance().tupleType(typeArray, stringArray);
        return kwTypes;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public Result<IValue> call(Type[] actualTypes, IValue[] actuals, Map<String, IValue> keyArgValues) {
        Type formalTypeParameters = this.constructorType.getAbstractDataType().getTypeParameters();
        Type fieldTypes = this.constructorType.getFieldTypes();
        if (fieldTypes.getArity() != actuals.length) {
            throw new MatchFailed();
        }
        for (int i = 0; i < actuals.length; ++i) {
            if (actuals[i].getType().isSubtypeOf(fieldTypes.getFieldType(i))) continue;
            throw new MatchFailed();
        }
        HashMap<Type, Type> bindings = new HashMap<Type, Type>();
        if (!fieldTypes.match(TF.tupleType(actualTypes), bindings)) {
            bindings = new HashMap();
            if (!formalTypeParameters.isBottom()) {
                for (Type field : formalTypeParameters) {
                    Type bound = field.getBound();
                    if (bound != null) {
                        bindings.put(field, bound);
                        continue;
                    }
                    bindings.put(field, TF.valueType());
                }
            }
        }
        if (this.constructorType == RascalValueFactory.Tree_Appl || this.constructorType == RascalValueFactory.Tree_Amb || this.constructorType == RascalValueFactory.Tree_Cycle || this.constructorType == RascalValueFactory.Tree_Char) {
            return new ConcreteConstructorFunction(this.ast, this.constructorType, this.eval, this.declarationEnvironment).call(actualTypes, actuals, keyArgValues);
        }
        Type instantiated = this.constructorType;
        if (!formalTypeParameters.isBottom()) {
            for (Type field : formalTypeParameters) {
                if (bindings.containsKey(field)) continue;
                bindings.put(field, TF.voidType());
            }
            instantiated = this.constructorType.instantiate(bindings);
        }
        return ResultFactory.makeResult(instantiated.getAbstractDataType(), this.ctx.getValueFactory().constructor(this.constructorType, actuals, keyArgValues), this.ctx);
    }

    @Override
    public int hashCode() {
        return this.constructorType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConstructorFunction) {
            return this.constructorType == ((ConstructorFunction)obj).constructorType;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.constructorType.toString();
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return that.equalToConstructorFunction(this);
    }

    @Override
    public Result<IBool> equalToConstructorFunction(ConstructorFunction that) {
        return ResultFactory.bool(this.constructorType == that.constructorType, this.ctx);
    }
}

