/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.IntegerResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.ListResult;
import org.rascalmpl.interpreter.result.MapResult;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.result.SetResult;
import org.rascalmpl.interpreter.result.ValueResult;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.values.RascalValueFactory;

public class ElementResult<T extends IValue>
extends Result<T> {
    public ElementResult(Type type, T value, IEvaluatorContext ctx) {
        super(type, value, ctx);
    }

    public ElementResult(Type type, T value, Iterator<Result<IValue>> iter, IEvaluatorContext ctx) {
        super(type, value, iter, ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> that) {
        return that.insertElement(this);
    }

    @Override
    protected Result<IBool> inSet(SetResult s2) {
        return s2.elementOf(this);
    }

    @Override
    protected Result<IBool> notInSet(SetResult s2) {
        return s2.notElementOf(this);
    }

    @Override
    protected Result<IBool> inRelation(RelationResult s2) {
        return s2.elementOf(this);
    }

    @Override
    protected Result<IBool> inListRelation(ListRelationResult s2) {
        return s2.elementOf(this);
    }

    @Override
    protected Result<IBool> notInRelation(RelationResult s2) {
        return s2.notElementOf(this);
    }

    @Override
    protected Result<IBool> notInListRelation(ListRelationResult s2) {
        return s2.notElementOf(this);
    }

    @Override
    protected Result<IBool> inList(ListResult s2) {
        return s2.elementOf(this);
    }

    @Override
    protected Result<IBool> notInList(ListResult s2) {
        return s2.notElementOf(this);
    }

    @Override
    protected Result<IBool> inMap(MapResult s2) {
        return s2.elementOf(this);
    }

    @Override
    protected Result<IBool> notInMap(MapResult s2) {
        return s2.notElementOf(this);
    }

    @Override
    protected <U extends IValue> Result<U> addSet(SetResult s2) {
        return s2.addElement(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractSet(SetResult s2) {
        return s2.removeElement(this);
    }

    @Override
    protected <U extends IValue> Result<U> addList(ListResult s2) {
        return s2.appendElement(this);
    }

    @Override
    protected <U extends IValue> Result<U> subtractList(ListResult s2) {
        return s2.removeElement(this);
    }

    @Override
    protected <U extends IValue> Result<U> addRelation(RelationResult that) {
        if (((ISet)that.getValue()).getElementType().isBottom()) {
            return ResultFactory.makeResult(this.getTypeFactory().setType(this.getStaticType()), ((ISet)that.getValue()).insert((IValue)this.getValue()), this.ctx);
        }
        return super.addRelation(that);
    }

    @Override
    protected <U extends IValue> Result<U> subtractRelation(RelationResult that) {
        if (that.getStaticType().getElementType().isBottom()) {
            return ResultFactory.makeResult(that.getStaticType(), that.getValue(), this.ctx);
        }
        return super.subtractRelation(that);
    }

    @Override
    protected <U extends IValue> Result<U> addListRelation(ListRelationResult that) {
        if (((IList)that.getValue()).getElementType().isBottom()) {
            return ResultFactory.makeResult(this.getTypeFactory().listType(this.getStaticType()), ((IList)that.getValue()).append((IValue)this.getValue()), this.ctx);
        }
        return super.addListRelation(that);
    }

    @Override
    protected <U extends IValue> Result<U> subtractListRelation(ListRelationResult that) {
        if (that.getStaticType().getElementType().isBottom()) {
            return ResultFactory.makeResult(that.getStaticType(), that.getValue(), this.ctx);
        }
        return super.subtractListRelation(that);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> setAnnotation(String annoName, Result<V> anno, Environment env) {
        Type annoType;
        if (RascalValueFactory.isLegacySourceLocationAnnotation(this.getStaticType(), annoName)) {
            annoName = "src";
            annoType = this.getTypeFactory().sourceLocationType();
        } else {
            annoType = env.getKeywordParameterTypes(this.getStaticType()).get(annoName);
        }
        if (this.getStaticType() != this.getTypeFactory().nodeType() && !anno.getStaticType().isSubtypeOf(annoType)) {
            throw new UnexpectedType(annoType, anno.getStaticType(), this.ctx.getCurrentAST());
        }
        INode annotatedBase = ((INode)this.getValue()).asWithKeywordParameters().setParameter(annoName, (IValue)anno.getValue());
        return ResultFactory.makeResult(this.getStaticType(), annotatedBase, this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> lessThan(Result<V> that) {
        return this.lessThanOrEqual(that).isLess();
    }

    @Override
    public <V extends IValue> LessThanOrEqualResult lessThanOrEqual(Result<V> that) {
        return new LessThanOrEqualResult(false, false, this.ctx);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThan(Result<V> that) {
        return that.lessThan(this);
    }

    @Override
    public <V extends IValue> Result<IBool> greaterThanOrEqual(Result<V> that) {
        return that.lessThanOrEqual(this);
    }

    @Override
    protected Result<IBool> equalToValue(ValueResult that) {
        return that.equalityBoolean(this);
    }

    protected <V extends IValue> Result<IBool> equalityBoolean(ElementResult<V> that) {
        Object a = that.getValue();
        Object b = this.getValue();
        return ResultFactory.bool(a.equals(b), this.ctx);
    }

    protected <V extends IValue> Result<IBool> nonEqualityBoolean(ElementResult<V> that) {
        Object b;
        Object a = that.getValue();
        return ResultFactory.bool(!a.equals(b = this.getValue()), this.ctx);
    }

    private int getInt(Result<?> x) {
        Result<?> key = x;
        if (!key.getStaticType().isInteger()) {
            throw new UnexpectedType(TypeFactory.getInstance().integerType(), key.getStaticType(), this.ctx.getCurrentAST());
        }
        return ((IInteger)key.getValue()).intValue();
    }

    public <U extends IValue, V extends IValue> Result<U> slice(Result<?> first, Result<?> second, Result<?> end, int len) {
        int firstIndex = 0;
        int secondIndex = 1;
        int endIndex = len;
        if (first != null && (firstIndex = this.getInt(first)) < 0) {
            firstIndex += len;
        }
        if (end != null && (endIndex = this.getInt(end)) < 0) {
            endIndex += len;
        }
        if (second == null) {
            secondIndex = firstIndex + (firstIndex <= endIndex ? 1 : -1);
        } else {
            secondIndex = this.getInt(second);
            if (secondIndex < 0) {
                secondIndex += len;
            }
            if (first != null || end != null) {
                if (first == null && secondIndex > endIndex) {
                    firstIndex = len - 1;
                }
                if (end == null && secondIndex < firstIndex) {
                    endIndex = -1;
                }
            }
        }
        if (len == 0 || firstIndex >= len) {
            return this.makeSlice(0, 1, 0);
        }
        if (endIndex > len) {
            return this.makeSlice(firstIndex, secondIndex, len);
        }
        return this.makeSlice(firstIndex, secondIndex, endIndex);
    }

    protected Result<? extends INumber> toReal(IntegerResult from) {
        return ResultFactory.makeResult(this.getTypeFactory().realType(), ((IInteger)from.getValue()).toReal(this.getValueFactory().getPrecision()), this.ctx);
    }
}

