/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Map;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ComposedFunctionResult;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.ListRelationResult;
import org.rascalmpl.interpreter.result.MapResult;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.RascalFunction;
import org.rascalmpl.interpreter.result.RelationResult;
import org.rascalmpl.interpreter.result.Result;

public final class FunctionResultFacade
extends Result<IValue> {
    private final Result<IValue> wrapped;
    private final Type functionType;

    protected FunctionResultFacade(Type type, Result<IValue> result, IEvaluatorContext ctx) {
        super(TypeFactory.getInstance().valueType(), result.getValue(), ctx);
        assert (type.comparable(result.getStaticType()));
        assert (result instanceof ICallableValue);
        this.wrapped = result;
        this.functionType = type;
    }

    @Override
    public Type getStaticType() {
        return this.functionType;
    }

    @Override
    public boolean hasNext() {
        return this.wrapped.hasNext();
    }

    @Override
    public Result<IValue> next() {
        return this.wrapped.next();
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) throws MatchFailed {
        return this.wrapped.call(argTypes, argValues, keyArgValues);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return this.wrapped.compose(right);
    }

    @Override
    public <V extends IValue> Result<IBool> equals(Result<V> that) {
        return this.wrapped.equals(that);
    }

    @Override
    public <V extends IValue> Result<IBool> nonEquals(Result<V> that) {
        return this.wrapped.nonEquals(that);
    }

    @Override
    protected <U extends IValue> Result<U> composeRelation(RelationResult that) {
        return this.wrapped.composeRelation(that);
    }

    @Override
    protected <U extends IValue> Result<U> composeListRelation(ListRelationResult that) {
        return this.wrapped.composeListRelation(that);
    }

    @Override
    public <U extends IValue> Result<U> composeMap(MapResult that) {
        return this.wrapped.composeMap(that);
    }

    @Override
    public <U extends IValue> Result<U> addFunctionNonDeterministic(AbstractFunction that) {
        return this.wrapped.addFunctionNonDeterministic(that);
    }

    @Override
    public <U extends IValue> Result<U> addFunctionNonDeterministic(OverloadedFunction that) {
        return this.wrapped.addFunctionNonDeterministic(that);
    }

    @Override
    public <U extends IValue> Result<U> addFunctionNonDeterministic(ComposedFunctionResult that) {
        return this.wrapped.addFunctionNonDeterministic(that);
    }

    @Override
    public <U extends IValue> Result<U> composeFunction(AbstractFunction that) {
        return this.wrapped.composeFunction(that);
    }

    @Override
    public <U extends IValue> Result<U> composeFunction(OverloadedFunction that) {
        return this.wrapped.composeFunction(that);
    }

    @Override
    public <U extends IValue> Result<U> composeFunction(ComposedFunctionResult that) {
        return this.wrapped.composeFunction(that);
    }

    @Override
    public Result<IBool> equalToOverloadedFunction(OverloadedFunction that) {
        return this.wrapped.equalToOverloadedFunction(that);
    }

    @Override
    public Result<IBool> equalToConstructorFunction(ConstructorFunction that) {
        return this.wrapped.equalToConstructorFunction(that);
    }

    @Override
    public Result<IBool> equalToRascalFunction(RascalFunction that) {
        return this.wrapped.equalToRascalFunction(that);
    }

    @Override
    public void setInferredType(boolean inferredType) {
        this.wrapped.setInferredType(inferredType);
    }

    @Override
    public boolean hasInferredType() {
        return this.wrapped.hasInferredType();
    }

    @Override
    public Type getKeywordArgumentTypes(Environment env) {
        return this.wrapped.getKeywordArgumentTypes(env);
    }
}

